/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.NullableSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class PercentileKLLAggregationFunction
extends NullableSingleInputAggregationFunction<KllDoublesSketch, Comparable<?>> {
    protected static final int DEFAULT_K_VALUE = 200;
    protected final double _percentile;
    protected int _kValue;

    public PercentileKLLAggregationFunction(List<ExpressionContext> arguments, boolean nullHandlingEnabled) {
        super(arguments.get(0), nullHandlingEnabled);
        int numArguments = arguments.size();
        Preconditions.checkArgument((numArguments == 2 || numArguments == 3 ? 1 : 0) != 0, (Object)"Expecting 2 or 3 arguments for PercentileKLL function: PERCENTILE_KLL(column, percentile, k=200");
        this._percentile = arguments.get(1).getLiteral().getDoubleValue();
        Preconditions.checkArgument((this._percentile >= 0.0 && this._percentile <= 100.0 ? 1 : 0) != 0, (Object)"Percentile value needs to be in range 0-100, inclusive");
        this._kValue = numArguments == 3 ? arguments.get(2).getLiteral().getIntValue() : 200;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.PERCENTILEKLL;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet valueSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType valueType = valueSet.getValueType();
        KllDoublesSketch sketch = this.getOrCreateSketch(aggregationResultHolder);
        if (valueType == FieldSpec.DataType.BYTES) {
            KllDoublesSketch[] deserializedSketches = this.deserializeSketches(blockValSetMap.get(this._expression).getBytesValuesSV());
            this.forEachNotNull(length, valueSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    sketch.merge((KllSketch)deserializedSketches[i]);
                }
            });
        } else {
            double[] values = valueSet.getDoubleValuesSV();
            this.forEachNotNull(length, valueSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    sketch.update(values[i]);
                }
            });
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet valueSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType valueType = valueSet.getValueType();
        if (valueType == FieldSpec.DataType.BYTES) {
            KllDoublesSketch[] deserializedSketches = this.deserializeSketches(blockValSetMap.get(this._expression).getBytesValuesSV());
            this.forEachNotNull(length, valueSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    KllDoublesSketch sketch = this.getOrCreateSketch(groupByResultHolder, groupKeyArray[i]);
                    sketch.merge((KllSketch)deserializedSketches[i]);
                }
            });
        } else {
            double[] values = valueSet.getDoubleValuesSV();
            this.forEachNotNull(length, valueSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    KllDoublesSketch sketch = this.getOrCreateSketch(groupByResultHolder, groupKeyArray[i]);
                    sketch.update(values[i]);
                }
            });
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet valueSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType valueType = valueSet.getValueType();
        if (valueType == FieldSpec.DataType.BYTES) {
            KllDoublesSketch[] deserializedSketches = this.deserializeSketches(blockValSetMap.get(this._expression).getBytesValuesSV());
            this.forEachNotNull(length, valueSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        KllDoublesSketch sketch = this.getOrCreateSketch(groupByResultHolder, groupKey);
                        sketch.merge((KllSketch)deserializedSketches[i]);
                    }
                }
            });
        } else {
            double[] values = valueSet.getDoubleValuesSV();
            this.forEachNotNull(length, valueSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        KllDoublesSketch sketch = this.getOrCreateSketch(groupByResultHolder, groupKey);
                        sketch.update(values[i]);
                    }
                }
            });
        }
    }

    protected KllDoublesSketch getOrCreateSketch(AggregationResultHolder aggregationResultHolder) {
        KllDoublesSketch sketch = (KllDoublesSketch)aggregationResultHolder.getResult();
        if (sketch == null) {
            sketch = KllDoublesSketch.newHeapInstance((int)this._kValue);
            aggregationResultHolder.setValue(sketch);
        }
        return sketch;
    }

    protected KllDoublesSketch getOrCreateSketch(GroupByResultHolder groupByResultHolder, int groupKey) {
        KllDoublesSketch sketch = (KllDoublesSketch)groupByResultHolder.getResult(groupKey);
        if (sketch == null) {
            sketch = KllDoublesSketch.newHeapInstance((int)this._kValue);
            groupByResultHolder.setValueForKey(groupKey, sketch);
        }
        return sketch;
    }

    protected KllDoublesSketch[] deserializeSketches(byte[][] serializedSketches) {
        KllDoublesSketch[] sketches = new KllDoublesSketch[serializedSketches.length];
        for (int i = 0; i < serializedSketches.length; ++i) {
            sketches[i] = KllDoublesSketch.wrap((Memory)Memory.wrap((byte[])serializedSketches[i]));
        }
        return sketches;
    }

    @Override
    public KllDoublesSketch extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return (KllDoublesSketch)aggregationResultHolder.getResult();
    }

    @Override
    public KllDoublesSketch extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return (KllDoublesSketch)groupByResultHolder.getResult(groupKey);
    }

    @Override
    public KllDoublesSketch merge(KllDoublesSketch sketch1, KllDoublesSketch sketch2) {
        KllDoublesSketch union = KllDoublesSketch.newHeapInstance((int)this._kValue);
        if (sketch1 != null) {
            union.merge((KllSketch)sketch1);
        }
        if (sketch2 != null) {
            union.merge((KllSketch)sketch2);
        }
        return union;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public String getResultColumnName() {
        return AggregationFunctionType.PERCENTILEKLL.getName().toLowerCase() + "(" + this._expression + ", " + this._percentile + ")";
    }

    @Override
    public Comparable<?> extractFinalResult(KllDoublesSketch sketch) {
        if (sketch.isEmpty() && this._nullHandlingEnabled) {
            return null;
        }
        return sketch.getQuantile(this._percentile / 100.0);
    }
}

