/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggFloatFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.roaringbitmap.RoaringBitmap;

public class ArrayAggDistinctFloatFunction
extends BaseArrayAggFloatFunction<FloatOpenHashSet> {
    public ArrayAggDistinctFloatFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
    }

    @Override
    protected void aggregateArray(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet) {
        FloatOpenHashSet valueArray = new FloatOpenHashSet(length);
        float[] value = blockValSet.getFloatValuesSV();
        for (int i = 0; i < length; ++i) {
            valueArray.add(value[i]);
        }
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void aggregateArrayWithNull(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet, RoaringBitmap nullBitmap) {
        FloatOpenHashSet valueArray = new FloatOpenHashSet(length);
        float[] value = blockValSet.getFloatValuesSV();
        for (int i = 0; i < length; ++i) {
            if (nullBitmap.contains(i)) continue;
            valueArray.add(value[i]);
        }
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void setGroupByResult(GroupByResultHolder resultHolder, int groupKey, float value) {
        FloatOpenHashSet valueSet = (FloatOpenHashSet)resultHolder.getResult(groupKey);
        if (valueSet == null) {
            valueSet = new FloatOpenHashSet();
            resultHolder.setValueForKey(groupKey, valueSet);
        }
        valueSet.add(value);
    }
}

