/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggIntFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class ArrayAggDistinctIntFunction
extends BaseArrayAggIntFunction<IntOpenHashSet> {
    public ArrayAggDistinctIntFunction(ExpressionContext expression, FieldSpec.DataType dataType, boolean nullHandlingEnabled) {
        super(expression, dataType, nullHandlingEnabled);
    }

    @Override
    protected void aggregateArray(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet) {
        int[] value = blockValSet.getIntValuesSV();
        IntOpenHashSet valueArray = new IntOpenHashSet(length);
        for (int i = 0; i < length; ++i) {
            valueArray.add(value[i]);
        }
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void aggregateArrayWithNull(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet, RoaringBitmap nullBitmap) {
        int[] value = blockValSet.getIntValuesSV();
        IntOpenHashSet valueArray = new IntOpenHashSet(length);
        for (int i = 0; i < length; ++i) {
            if (nullBitmap.contains(i)) continue;
            valueArray.add(value[i]);
        }
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void setGroupByResult(GroupByResultHolder resultHolder, int groupKey, int value) {
        IntOpenHashSet valueSet = (IntOpenHashSet)resultHolder.getResult(groupKey);
        if (valueSet == null) {
            valueSet = new IntOpenHashSet();
            resultHolder.setValueForKey(groupKey, valueSet);
        }
        valueSet.add(value);
    }
}

