/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggLongFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class ArrayAggDistinctLongFunction
extends BaseArrayAggLongFunction<LongOpenHashSet> {
    public ArrayAggDistinctLongFunction(ExpressionContext expression, FieldSpec.DataType dataType, boolean nullHandlingEnabled) {
        super(expression, dataType, nullHandlingEnabled);
    }

    @Override
    protected void aggregateArray(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet) {
        long[] value = blockValSet.getLongValuesSV();
        LongOpenHashSet valueArray = new LongOpenHashSet(length);
        for (int i = 0; i < length; ++i) {
            valueArray.add(value[i]);
        }
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void aggregateArrayWithNull(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet, RoaringBitmap nullBitmap) {
        long[] value = blockValSet.getLongValuesSV();
        LongOpenHashSet valueArray = new LongOpenHashSet(length);
        for (int i = 0; i < length; ++i) {
            if (nullBitmap.contains(i)) continue;
            valueArray.add(value[i]);
        }
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void setGroupByResult(GroupByResultHolder resultHolder, int groupKey, long value) {
        LongOpenHashSet valueSet = (LongOpenHashSet)resultHolder.getResult(groupKey);
        if (valueSet == null) {
            valueSet = new LongOpenHashSet();
            resultHolder.setValueForKey(groupKey, valueSet);
        }
        valueSet.add(value);
    }
}

