/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggStringFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.roaringbitmap.RoaringBitmap;

public class ArrayAggDistinctStringFunction
extends BaseArrayAggStringFunction<ObjectOpenHashSet<String>> {
    public ArrayAggDistinctStringFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
    }

    @Override
    protected void aggregateArray(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet) {
        ObjectOpenHashSet valueArray = new ObjectOpenHashSet(length);
        String[] value = blockValSet.getStringValuesSV();
        valueArray.addAll(Arrays.asList(value));
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void aggregateArrayWithNull(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet, RoaringBitmap nullBitmap) {
        ObjectOpenHashSet valueArray = new ObjectOpenHashSet(length);
        String[] value = blockValSet.getStringValuesSV();
        for (int i = 0; i < length; ++i) {
            if (nullBitmap.contains(i)) continue;
            valueArray.add((Object)value[i]);
        }
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void setGroupByResult(GroupByResultHolder resultHolder, int groupKey, String value) {
        ObjectOpenHashSet valueSet = (ObjectOpenHashSet)resultHolder.getResult(groupKey);
        if (valueSet == null) {
            valueSet = new ObjectOpenHashSet();
            resultHolder.setValueForKey(groupKey, valueSet);
        }
        valueSet.add((Object)value);
    }
}

