/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggDoubleFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.roaringbitmap.RoaringBitmap;

public class ArrayAggDoubleFunction
extends BaseArrayAggDoubleFunction<DoubleArrayList> {
    public ArrayAggDoubleFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
    }

    @Override
    protected void aggregateArray(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet) {
        DoubleArrayList valueArray = new DoubleArrayList(length);
        double[] value = blockValSet.getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            valueArray.add(value[i]);
        }
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void aggregateArrayWithNull(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet, RoaringBitmap nullBitmap) {
        DoubleArrayList valueArray = new DoubleArrayList(length);
        double[] value = blockValSet.getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            if (nullBitmap.contains(i)) continue;
            valueArray.add(value[i]);
        }
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void setGroupByResult(GroupByResultHolder resultHolder, int groupKey, double value) {
        DoubleArrayList valueArray = (DoubleArrayList)resultHolder.getResult(groupKey);
        if (valueArray == null) {
            valueArray = new DoubleArrayList();
            resultHolder.setValueForKey(groupKey, valueArray);
        }
        valueArray.add(value);
    }
}

