/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.floats.FloatArrayList;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggFloatFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.roaringbitmap.RoaringBitmap;

public class ArrayAggFloatFunction
extends BaseArrayAggFloatFunction<FloatArrayList> {
    public ArrayAggFloatFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
    }

    @Override
    protected void aggregateArray(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet) {
        FloatArrayList valueArray = new FloatArrayList(length);
        float[] value = blockValSet.getFloatValuesSV();
        for (int i = 0; i < length; ++i) {
            valueArray.add(value[i]);
        }
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void aggregateArrayWithNull(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet, RoaringBitmap nullBitmap) {
        FloatArrayList valueArray = new FloatArrayList(length);
        float[] value = blockValSet.getFloatValuesSV();
        for (int i = 0; i < length; ++i) {
            if (nullBitmap.contains(i)) continue;
            valueArray.add(value[i]);
        }
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void setGroupByResult(GroupByResultHolder resultHolder, int groupKey, float value) {
        FloatArrayList valueArray = (FloatArrayList)resultHolder.getResult(groupKey);
        if (valueArray == null) {
            valueArray = new FloatArrayList();
            resultHolder.setValueForKey(groupKey, valueArray);
        }
        valueArray.add(value);
    }
}

