/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggStringFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.roaringbitmap.RoaringBitmap;

public class ArrayAggStringFunction
extends BaseArrayAggStringFunction<ObjectArrayList<String>> {
    public ArrayAggStringFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
    }

    @Override
    protected void aggregateArray(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet) {
        ObjectArrayList valueArray = new ObjectArrayList(length);
        String[] value = blockValSet.getStringValuesSV();
        valueArray.addAll(Arrays.asList(value));
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void aggregateArrayWithNull(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet, RoaringBitmap nullBitmap) {
        ObjectArrayList valueArray = new ObjectArrayList(length);
        String[] value = blockValSet.getStringValuesSV();
        for (int i = 0; i < length; ++i) {
            if (nullBitmap.contains(i)) continue;
            valueArray.add((Object)value[i]);
        }
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void setGroupByResult(GroupByResultHolder resultHolder, int groupKey, String value) {
        ObjectArrayList valueArray = (ObjectArrayList)resultHolder.getResult(groupKey);
        if (valueArray == null) {
            valueArray = new ObjectArrayList();
            resultHolder.setValueForKey(groupKey, valueArray);
        }
        valueArray.add((Object)value);
    }
}

