/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public abstract class BaseArrayAggFloatFunction<I extends AbstractFloatCollection>
extends BaseArrayAggFunction<I, FloatArrayList> {
    public BaseArrayAggFloatFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression, FieldSpec.DataType.FLOAT, nullHandlingEnabled);
    }

    abstract void setGroupByResult(GroupByResultHolder var1, int var2, float var3);

    @Override
    protected void aggregateArrayGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet) {
        float[] values = blockValSet.getFloatValuesSV();
        for (int i = 0; i < length; ++i) {
            this.setGroupByResult(groupByResultHolder, groupKeyArray[i], values[i]);
        }
    }

    @Override
    protected void aggregateArrayGroupBySVWithNull(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, RoaringBitmap nullBitmap) {
        float[] values = blockValSet.getFloatValuesSV();
        for (int i = 0; i < length; ++i) {
            if (nullBitmap.contains(i)) continue;
            this.setGroupByResult(groupByResultHolder, groupKeyArray[i], values[i]);
        }
    }

    @Override
    protected void aggregateArrayGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet) {
        float[] values = blockValSet.getFloatValuesSV();
        for (int i = 0; i < length; ++i) {
            for (int groupKey : groupKeysArray[i]) {
                this.setGroupByResult(groupByResultHolder, groupKey, values[i]);
            }
        }
    }

    @Override
    protected void aggregateArrayGroupByMVWithNull(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, RoaringBitmap nullBitmap) {
        float[] values = blockValSet.getFloatValuesSV();
        for (int i = 0; i < length; ++i) {
            for (int groupKey : groupKeysArray[i]) {
                if (nullBitmap.contains(i)) continue;
                this.setGroupByResult(groupByResultHolder, groupKey, values[i]);
            }
        }
    }

    @Override
    public I merge(I intermediateResult1, I intermediateResult2) {
        if (intermediateResult1 == null) {
            return intermediateResult2;
        }
        if (intermediateResult2 == null) {
            return intermediateResult1;
        }
        intermediateResult1.addAll(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public FloatArrayList extractFinalResult(I floatArrayList) {
        if (floatArrayList == null) {
            return new FloatArrayList();
        }
        return new FloatArrayList(floatArrayList);
    }
}

