/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public abstract class BaseArrayAggFunction<I, F extends Comparable>
extends BaseSingleInputAggregationFunction<I, F> {
    protected final boolean _nullHandlingEnabled;
    private final DataSchema.ColumnDataType _resultColumnType;

    public BaseArrayAggFunction(ExpressionContext expression, FieldSpec.DataType dataType, boolean nullHandlingEnabled) {
        super(expression);
        this._nullHandlingEnabled = nullHandlingEnabled;
        this._resultColumnType = DataSchema.ColumnDataType.fromDataTypeMV((FieldSpec.DataType)dataType);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.ARRAYAGG;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return this._resultColumnType;
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        RoaringBitmap nullBitmap;
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (this._nullHandlingEnabled && (nullBitmap = blockValSet.getNullBitmap()) != null && !nullBitmap.isEmpty()) {
            this.aggregateArrayWithNull(length, aggregationResultHolder, blockValSet, nullBitmap);
            return;
        }
        this.aggregateArray(length, aggregationResultHolder, blockValSet);
    }

    protected abstract void aggregateArray(int var1, AggregationResultHolder var2, BlockValSet var3);

    protected abstract void aggregateArrayWithNull(int var1, AggregationResultHolder var2, BlockValSet var3, RoaringBitmap var4);

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        RoaringBitmap nullBitmap;
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (this._nullHandlingEnabled && (nullBitmap = blockValSet.getNullBitmap()) != null && !nullBitmap.isEmpty()) {
            this.aggregateArrayGroupBySVWithNull(length, groupKeyArray, groupByResultHolder, blockValSet, nullBitmap);
            return;
        }
        this.aggregateArrayGroupBySV(length, groupKeyArray, groupByResultHolder, blockValSet);
    }

    protected abstract void aggregateArrayGroupBySV(int var1, int[] var2, GroupByResultHolder var3, BlockValSet var4);

    protected abstract void aggregateArrayGroupBySVWithNull(int var1, int[] var2, GroupByResultHolder var3, BlockValSet var4, RoaringBitmap var5);

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        RoaringBitmap nullBitmap;
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (this._nullHandlingEnabled && (nullBitmap = blockValSet.getNullBitmap()) != null && !nullBitmap.isEmpty()) {
            this.aggregateArrayGroupByMVWithNull(length, groupKeysArray, groupByResultHolder, blockValSet, nullBitmap);
            return;
        }
        this.aggregateArrayGroupByMV(length, groupKeysArray, groupByResultHolder, blockValSet);
    }

    protected abstract void aggregateArrayGroupByMV(int var1, int[][] var2, GroupByResultHolder var3, BlockValSet var4);

    protected abstract void aggregateArrayGroupByMVWithNull(int var1, int[][] var2, GroupByResultHolder var3, BlockValSet var4, RoaringBitmap var5);

    @Override
    public I extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return (I)aggregationResultHolder.getResult();
    }

    @Override
    public I extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return (I)groupByResultHolder.getResult(groupKey);
    }
}

