/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public abstract class BaseArrayAggIntFunction<I extends AbstractIntCollection>
extends BaseArrayAggFunction<I, IntArrayList> {
    public BaseArrayAggIntFunction(ExpressionContext expression, FieldSpec.DataType dataType, boolean nullHandlingEnabled) {
        super(expression, dataType, nullHandlingEnabled);
    }

    abstract void setGroupByResult(GroupByResultHolder var1, int var2, int var3);

    @Override
    protected void aggregateArrayGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet) {
        int[] values = blockValSet.getIntValuesSV();
        for (int i = 0; i < length; ++i) {
            this.setGroupByResult(groupByResultHolder, groupKeyArray[i], values[i]);
        }
    }

    @Override
    protected void aggregateArrayGroupBySVWithNull(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, RoaringBitmap nullBitmap) {
        int[] values = blockValSet.getIntValuesSV();
        for (int i = 0; i < length; ++i) {
            if (nullBitmap.contains(i)) continue;
            this.setGroupByResult(groupByResultHolder, groupKeyArray[i], values[i]);
        }
    }

    @Override
    protected void aggregateArrayGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet) {
        int[] values = blockValSet.getIntValuesSV();
        for (int i = 0; i < length; ++i) {
            int[] groupKeys = groupKeysArray[i];
            int value = values[i];
            for (int groupKey : groupKeys) {
                this.setGroupByResult(groupByResultHolder, groupKey, value);
            }
        }
    }

    @Override
    protected void aggregateArrayGroupByMVWithNull(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, RoaringBitmap nullBitmap) {
        int[] values = blockValSet.getIntValuesSV();
        for (int i = 0; i < length; ++i) {
            if (nullBitmap.contains(i)) continue;
            int[] groupKeys = groupKeysArray[i];
            int value = values[i];
            for (int groupKey : groupKeys) {
                this.setGroupByResult(groupByResultHolder, groupKey, value);
            }
        }
    }

    @Override
    public I merge(I intermediateResult1, I intermediateResult2) {
        if (intermediateResult1 == null || intermediateResult1.isEmpty()) {
            return intermediateResult2;
        }
        if (intermediateResult2 == null || intermediateResult2.isEmpty()) {
            return intermediateResult1;
        }
        intermediateResult1.addAll(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public IntArrayList extractFinalResult(I intArrayList) {
        if (intArrayList == null) {
            return new IntArrayList();
        }
        return new IntArrayList(intArrayList);
    }
}

