/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public abstract class BaseArrayAggLongFunction<I extends AbstractLongCollection>
extends BaseArrayAggFunction<I, LongArrayList> {
    public BaseArrayAggLongFunction(ExpressionContext expression, FieldSpec.DataType dataType, boolean nullHandlingEnabled) {
        super(expression, dataType, nullHandlingEnabled);
    }

    abstract void setGroupByResult(GroupByResultHolder var1, int var2, long var3);

    @Override
    protected void aggregateArrayGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet) {
        long[] values = blockValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            this.setGroupByResult(groupByResultHolder, groupKeyArray[i], values[i]);
        }
    }

    @Override
    protected void aggregateArrayGroupBySVWithNull(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, RoaringBitmap nullBitmap) {
        long[] values = blockValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            if (nullBitmap.contains(i)) continue;
            this.setGroupByResult(groupByResultHolder, groupKeyArray[i], values[i]);
        }
    }

    @Override
    protected void aggregateArrayGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet) {
        long[] values = blockValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            int[] groupKeys;
            for (int groupKey : groupKeys = groupKeysArray[i]) {
                this.setGroupByResult(groupByResultHolder, groupKey, values[i]);
            }
        }
    }

    @Override
    protected void aggregateArrayGroupByMVWithNull(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, RoaringBitmap nullBitmap) {
        long[] values = blockValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            int[] groupKeys;
            if (nullBitmap.contains(i)) continue;
            for (int groupKey : groupKeys = groupKeysArray[i]) {
                this.setGroupByResult(groupByResultHolder, groupKey, values[i]);
            }
        }
    }

    @Override
    public I merge(I intermediateResult1, I intermediateResult2) {
        if (intermediateResult1 == null || intermediateResult1.isEmpty()) {
            return intermediateResult2;
        }
        if (intermediateResult2 == null || intermediateResult2.isEmpty()) {
            return intermediateResult1;
        }
        intermediateResult1.addAll(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public LongArrayList extractFinalResult(I arrayList) {
        if (arrayList == null) {
            return new LongArrayList();
        }
        return new LongArrayList(arrayList);
    }
}

