/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.funnel;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.spi.index.reader.Dictionary;

@ThreadSafe
public abstract class AggregationStrategy<A> {
    protected final int _numSteps;
    private final List<ExpressionContext> _stepExpressions;
    private final List<ExpressionContext> _correlateByExpressions;
    private final ExpressionContext _primaryCorrelationCol;

    public AggregationStrategy(List<ExpressionContext> stepExpressions, List<ExpressionContext> correlateByExpressions) {
        this._stepExpressions = stepExpressions;
        this._correlateByExpressions = correlateByExpressions;
        this._primaryCorrelationCol = this._correlateByExpressions.get(0);
        this._numSteps = this._stepExpressions.size();
    }

    abstract A createAggregationResult(Dictionary var1);

    public A getAggregationResultGroupBy(Dictionary dictionary, GroupByResultHolder groupByResultHolder, int groupKey) {
        Object aggResult = groupByResultHolder.getResult(groupKey);
        if (aggResult == null) {
            aggResult = this.createAggregationResult(dictionary);
            groupByResultHolder.setValueForKey(groupKey, aggResult);
        }
        return (A)aggResult;
    }

    public A getAggregationResult(Dictionary dictionary, AggregationResultHolder aggregationResultHolder) {
        Object aggResult = aggregationResultHolder.getResult();
        if (aggResult == null) {
            aggResult = this.createAggregationResult(dictionary);
            aggregationResultHolder.setValue(aggResult);
        }
        return (A)aggResult;
    }

    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        Dictionary dictionary = this.getDictionary(blockValSetMap);
        int[] correlationIds = this.getCorrelationIds(blockValSetMap);
        int[][] steps = this.getSteps(blockValSetMap);
        A aggResult = this.getAggregationResult(dictionary, aggregationResultHolder);
        for (int i = 0; i < length; ++i) {
            for (int n = 0; n < this._numSteps; ++n) {
                if (steps[n][i] <= 0) continue;
                this.add(dictionary, aggResult, n, correlationIds[i]);
            }
        }
    }

    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        Dictionary dictionary = this.getDictionary(blockValSetMap);
        int[] correlationIds = this.getCorrelationIds(blockValSetMap);
        int[][] steps = this.getSteps(blockValSetMap);
        for (int i = 0; i < length; ++i) {
            for (int n = 0; n < this._numSteps; ++n) {
                int groupKey = groupKeyArray[i];
                A aggResult = this.getAggregationResultGroupBy(dictionary, groupByResultHolder, groupKey);
                if (steps[n][i] <= 0) continue;
                this.add(dictionary, aggResult, n, correlationIds[i]);
            }
        }
    }

    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        Dictionary dictionary = this.getDictionary(blockValSetMap);
        int[] correlationIds = this.getCorrelationIds(blockValSetMap);
        int[][] steps = this.getSteps(blockValSetMap);
        for (int i = 0; i < length; ++i) {
            for (int n = 0; n < this._numSteps; ++n) {
                for (int groupKey : groupKeysArray[i]) {
                    A aggResult = this.getAggregationResultGroupBy(dictionary, groupByResultHolder, groupKey);
                    if (steps[n][i] <= 0) continue;
                    this.add(dictionary, aggResult, n, correlationIds[i]);
                }
            }
        }
    }

    abstract void add(Dictionary var1, A var2, int var3, int var4);

    private Dictionary getDictionary(Map<ExpressionContext, BlockValSet> blockValSetMap) {
        Dictionary primaryCorrelationDictionary = blockValSetMap.get(this._primaryCorrelationCol).getDictionary();
        Preconditions.checkArgument((primaryCorrelationDictionary != null ? 1 : 0) != 0, (Object)"CORRELATE_BY column in FUNNELCOUNT aggregation function not supported, please use a dictionary encoded column.");
        return primaryCorrelationDictionary;
    }

    private int[] getCorrelationIds(Map<ExpressionContext, BlockValSet> blockValSetMap) {
        return blockValSetMap.get(this._primaryCorrelationCol).getDictionaryIdsSV();
    }

    private int[][] getSteps(Map<ExpressionContext, BlockValSet> blockValSetMap) {
        int[][] steps = new int[this._numSteps][];
        for (int n = 0; n < this._numSteps; ++n) {
            BlockValSet stepBlockValSet = blockValSetMap.get(this._stepExpressions.get(n));
            steps[n] = stepBlockValSet.getIntValuesSV();
        }
        return steps;
    }
}

