/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.funnel;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.funnel.AggregationStrategy;
import org.apache.pinot.core.query.aggregation.function.funnel.MergeStrategy;
import org.apache.pinot.core.query.aggregation.function.funnel.ResultExtractionStrategy;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class FunnelCountAggregationFunction<A, I>
implements AggregationFunction<I, LongArrayList> {
    private final List<ExpressionContext> _expressions;
    private final List<ExpressionContext> _stepExpressions;
    private final List<ExpressionContext> _correlateByExpressions;
    private final int _numSteps;
    private final AggregationStrategy<A> _aggregationStrategy;
    private final ResultExtractionStrategy<A, I> _resultExtractionStrategy;
    private final MergeStrategy<I> _mergeStrategy;

    public FunnelCountAggregationFunction(List<ExpressionContext> expressions, List<ExpressionContext> stepExpressions, List<ExpressionContext> correlateByExpressions, AggregationStrategy<A> aggregationStrategy, ResultExtractionStrategy<A, I> resultExtractionStrategy, MergeStrategy<I> mergeStrategy) {
        this._expressions = expressions;
        this._stepExpressions = stepExpressions;
        this._correlateByExpressions = correlateByExpressions;
        this._aggregationStrategy = aggregationStrategy;
        this._resultExtractionStrategy = resultExtractionStrategy;
        this._mergeStrategy = mergeStrategy;
        this._numSteps = this._stepExpressions.size();
    }

    @Override
    public String getResultColumnName() {
        return this.getType().getName().toLowerCase() + "(" + this._expressions.stream().map(ExpressionContext::toString).collect(Collectors.joining(",")) + ")";
    }

    @Override
    public List<ExpressionContext> getInputExpressions() {
        ArrayList<ExpressionContext> inputs = new ArrayList<ExpressionContext>();
        inputs.addAll(this._correlateByExpressions);
        inputs.addAll(this._stepExpressions);
        return inputs;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.FUNNELCOUNT;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        this._aggregationStrategy.aggregate(length, aggregationResultHolder, blockValSetMap);
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        this._aggregationStrategy.aggregateGroupBySV(length, groupKeyArray, groupByResultHolder, blockValSetMap);
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        this._aggregationStrategy.aggregateGroupByMV(length, groupKeysArray, groupByResultHolder, blockValSetMap);
    }

    @Override
    public I extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return this._resultExtractionStrategy.extractAggregationResult(aggregationResultHolder);
    }

    @Override
    public I extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return this._resultExtractionStrategy.extractGroupByResult(groupByResultHolder, groupKey);
    }

    @Override
    public I merge(I a, I b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return this._mergeStrategy.merge(a, b);
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.LONG_ARRAY;
    }

    @Override
    public LongArrayList extractFinalResult(I intermediateResult) {
        if (intermediateResult == null) {
            return new LongArrayList(this._numSteps);
        }
        return this._mergeStrategy.extractFinalResult(intermediateResult);
    }

    @Override
    public LongArrayList mergeFinalResult(LongArrayList finalResult1, LongArrayList finalResult2) {
        long[] elements1 = finalResult1.elements();
        long[] elements2 = finalResult2.elements();
        for (int i = 0; i < this._numSteps; ++i) {
            int n = i;
            elements1[n] = elements1[n] + elements2[i];
        }
        return finalResult1;
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(this.getType().getName()).append('(');
        int numArguments = this.getInputExpressions().size();
        if (numArguments > 0) {
            stringBuilder.append(this.getInputExpressions().get(0).toString());
            for (int i = 1; i < numArguments; ++i) {
                stringBuilder.append(", ").append(this.getInputExpressions().get(i).toString());
            }
        }
        return stringBuilder.append(')').toString();
    }
}

