/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.funnel;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.funnel.AggregationStrategy;
import org.apache.pinot.core.query.aggregation.function.funnel.BitmapAggregationStrategy;
import org.apache.pinot.core.query.aggregation.function.funnel.BitmapMergeStrategy;
import org.apache.pinot.core.query.aggregation.function.funnel.BitmapResultExtractionStrategy;
import org.apache.pinot.core.query.aggregation.function.funnel.DictIdsWrapper;
import org.apache.pinot.core.query.aggregation.function.funnel.FunnelCountAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.funnel.FunnelCountSortedAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.funnel.MergeStrategy;
import org.apache.pinot.core.query.aggregation.function.funnel.PartitionedMergeStrategy;
import org.apache.pinot.core.query.aggregation.function.funnel.ResultExtractionStrategy;
import org.apache.pinot.core.query.aggregation.function.funnel.SetMergeStrategy;
import org.apache.pinot.core.query.aggregation.function.funnel.SetResultExtractionStrategy;
import org.apache.pinot.core.query.aggregation.function.funnel.ThetaSketchAggregationStrategy;
import org.apache.pinot.core.query.aggregation.function.funnel.ThetaSketchMergeStrategy;
import org.apache.pinot.core.query.aggregation.function.funnel.ThetaSketchResultExtractionStrategy;
import org.roaringbitmap.RoaringBitmap;

public class FunnelCountAggregationFunctionFactory
implements Supplier<AggregationFunction> {
    final List<ExpressionContext> _expressions;
    final List<ExpressionContext> _stepExpressions;
    final List<ExpressionContext> _correlateByExpressions;
    final ExpressionContext _primaryCorrelationCol;
    final int _numSteps;
    final int _nominalEntries;
    final boolean _partitionSetting;
    final boolean _sortingSetting;
    final boolean _thetaSketchSetting;
    final boolean _setSetting;

    public FunnelCountAggregationFunctionFactory(List<ExpressionContext> expressions) {
        this._expressions = expressions;
        Option.validate(expressions);
        this._correlateByExpressions = Option.CORRELATE_BY.getInputExpressions(expressions);
        this._primaryCorrelationCol = this._correlateByExpressions.get(0);
        this._stepExpressions = Option.STEPS.getInputExpressions(expressions);
        this._numSteps = this._stepExpressions.size();
        List<String> settings = Option.SETTINGS.getLiterals(expressions);
        Setting.validate(settings);
        this._setSetting = Setting.SET.isSet(settings);
        this._partitionSetting = Setting.PARTITIONED.isSet(settings);
        this._sortingSetting = Setting.SORTED.isSet(settings);
        this._thetaSketchSetting = Setting.THETA_SKETCH.isSet(settings);
        this._nominalEntries = Setting.NOMINAL_ENTRIES.getInteger(settings).orElse(4096);
    }

    @Override
    public AggregationFunction get() {
        if (this._partitionSetting) {
            if (this._thetaSketchSetting) {
                return this.createPartionedFunnelCountAggregationFunction(this.thetaSketchAggregationStrategy(), this.thetaSketchPartitionedResultExtractionStrategy(), this.partitionedMergeStrategy());
            }
            return this.createPartionedFunnelCountAggregationFunction(this.bitmapAggregationStrategy(), this.bitmapPartitionedResultExtractionStrategy(), this.partitionedMergeStrategy());
        }
        if (this._thetaSketchSetting) {
            return this.createFunnelCountAggregationFunction(this.thetaSketchAggregationStrategy(), this.thetaSketchResultExtractionStrategy(), this.thetaSketchMergeStrategy());
        }
        if (this._setSetting) {
            return this.createFunnelCountAggregationFunction(this.bitmapAggregationStrategy(), this.setResultExtractionStrategy(), this.setMergeStrategy());
        }
        return this.createFunnelCountAggregationFunction(this.bitmapAggregationStrategy(), this.bitmapResultExtractionStrategy(), this.bitmapMergeStrategy());
    }

    private <A, I> FunnelCountAggregationFunction<A, I> createFunnelCountAggregationFunction(AggregationStrategy<A> aggregationStrategy, ResultExtractionStrategy<A, I> resultExtractionStrategy, MergeStrategy<I> mergeStrategy) {
        return new FunnelCountAggregationFunction<A, I>(this._expressions, this._stepExpressions, this._correlateByExpressions, aggregationStrategy, resultExtractionStrategy, mergeStrategy);
    }

    private <A> FunnelCountAggregationFunction<A, List<Long>> createPartionedFunnelCountAggregationFunction(AggregationStrategy<A> aggregationStrategy, ResultExtractionStrategy<A, List<Long>> resultExtractionStrategy, MergeStrategy<List<Long>> mergeStrategy) {
        if (this._sortingSetting) {
            return new FunnelCountSortedAggregationFunction<A>(this._expressions, this._stepExpressions, this._correlateByExpressions, aggregationStrategy, resultExtractionStrategy, mergeStrategy);
        }
        return new FunnelCountAggregationFunction<A, List<Long>>(this._expressions, this._stepExpressions, this._correlateByExpressions, aggregationStrategy, resultExtractionStrategy, mergeStrategy);
    }

    AggregationStrategy<UpdateSketch[]> thetaSketchAggregationStrategy() {
        return new ThetaSketchAggregationStrategy(this._stepExpressions, this._correlateByExpressions, this._nominalEntries);
    }

    AggregationStrategy<DictIdsWrapper> bitmapAggregationStrategy() {
        return new BitmapAggregationStrategy(this._stepExpressions, this._correlateByExpressions);
    }

    MergeStrategy<List<Sketch>> thetaSketchMergeStrategy() {
        return new ThetaSketchMergeStrategy(this._numSteps, this._nominalEntries);
    }

    MergeStrategy<List<Set>> setMergeStrategy() {
        return new SetMergeStrategy(this._numSteps);
    }

    MergeStrategy<List<RoaringBitmap>> bitmapMergeStrategy() {
        return new BitmapMergeStrategy(this._numSteps);
    }

    MergeStrategy<List<Long>> partitionedMergeStrategy() {
        return new PartitionedMergeStrategy(this._numSteps);
    }

    ResultExtractionStrategy<UpdateSketch[], List<Sketch>> thetaSketchResultExtractionStrategy() {
        return new ThetaSketchResultExtractionStrategy(this._numSteps);
    }

    ResultExtractionStrategy<DictIdsWrapper, List<Set>> setResultExtractionStrategy() {
        return new SetResultExtractionStrategy(this._numSteps);
    }

    ResultExtractionStrategy<DictIdsWrapper, List<RoaringBitmap>> bitmapResultExtractionStrategy() {
        return new BitmapResultExtractionStrategy(this._numSteps);
    }

    ResultExtractionStrategy<DictIdsWrapper, List<Long>> bitmapPartitionedResultExtractionStrategy() {
        MergeStrategy<List<RoaringBitmap>> bitmapMergeStrategy = this.bitmapMergeStrategy();
        return dictIdsWrapper -> bitmapMergeStrategy.extractFinalResult(Arrays.asList(dictIdsWrapper._stepsBitmaps));
    }

    ResultExtractionStrategy<UpdateSketch[], List<Long>> thetaSketchPartitionedResultExtractionStrategy() {
        MergeStrategy<List<Sketch>> thetaSketchMergeStrategy = this.thetaSketchMergeStrategy();
        return sketches -> thetaSketchMergeStrategy.extractFinalResult(Arrays.asList(sketches));
    }

    static enum Setting {
        SET("set"),
        BITMAP("bitmap"),
        PARTITIONED("partitioned"),
        SORTED("sorted"),
        THETA_SKETCH("theta_sketch"),
        NOMINAL_ENTRIES("nominalEntries");

        private static final char KEY_VALUE_SEPARATOR = '=';
        final String _name;

        private Setting(String name) {
            this._name = name.toLowerCase();
        }

        public static void validate(List<String> settings) {
            List invalidSettings = settings.stream().filter(param -> !Arrays.stream(Setting.values()).anyMatch(setting -> setting.matchesKV((String)param) || setting.matches((String)param))).collect(Collectors.toList());
            if (!invalidSettings.isEmpty()) {
                throw new IllegalArgumentException("Invalid FUNNELCOUNT SETTINGS: " + String.join((CharSequence)", ", invalidSettings));
            }
        }

        boolean matchesKV(String setting) {
            return StringUtils.deleteWhitespace((String)setting).toLowerCase().startsWith(this._name + "=");
        }

        boolean matches(String setting) {
            return StringUtils.deleteWhitespace((String)setting).toLowerCase().equals(this._name);
        }

        public Optional<String> getString(List<String> settings) {
            return settings.stream().filter(this::matchesKV).findFirst().map(setting -> setting.substring(this._name.length() + 1));
        }

        public Optional<Integer> getInteger(List<String> settings) {
            return this.getString(settings).map(Integer::parseInt);
        }

        public boolean isSet(List<String> settings) {
            return settings.stream().anyMatch(this::matches) || this.getString(settings).map(Boolean::parseBoolean).orElse(false) != false;
        }
    }

    static enum Option {
        STEPS("steps"),
        CORRELATE_BY("correlateby"),
        SETTINGS("settings");

        final String _name;

        private Option(String name) {
            this._name = name;
        }

        public static void validate(List<ExpressionContext> expressions) {
            List invalidOptions = expressions.stream().filter(expression -> !Arrays.stream(Option.values()).anyMatch(option -> option.matches((ExpressionContext)expression))).map(ExpressionContext::toString).collect(Collectors.toList());
            if (!invalidOptions.isEmpty()) {
                throw new IllegalArgumentException("Invalid FUNNELCOUNT options: " + String.join((CharSequence)", ", invalidOptions));
            }
        }

        boolean matches(ExpressionContext expression) {
            if (expression.getType() != ExpressionContext.Type.FUNCTION) {
                return false;
            }
            return this._name.equals(expression.getFunction().getFunctionName());
        }

        Optional<ExpressionContext> find(List<ExpressionContext> expressions) {
            return expressions.stream().filter(this::matches).findFirst();
        }

        public List<ExpressionContext> getInputExpressions(List<ExpressionContext> expressions) {
            List inputExpressions = this.find(expressions).map(exp -> exp.getFunction().getArguments()).orElseThrow(() -> new IllegalArgumentException("FUNNELCOUNT requires " + this._name));
            Preconditions.checkArgument((!inputExpressions.isEmpty() ? 1 : 0) != 0, (Object)("FUNNELCOUNT: " + this._name + " requires an argument."));
            return inputExpressions;
        }

        public List<String> getLiterals(List<ExpressionContext> expressions) {
            List inputExpressions = this.find(expressions).map(exp -> exp.getFunction().getArguments()).orElseGet(Collections::emptyList);
            Preconditions.checkArgument((boolean)inputExpressions.stream().allMatch(exp -> exp.getType() == ExpressionContext.Type.LITERAL), (Object)("FUNNELCOUNT: " + this._name + " parameters must be literals"));
            return inputExpressions.stream().map(exp -> exp.getLiteral().getStringValue()).collect(Collectors.toList());
        }
    }
}

