/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.funnel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class FunnelStepEvent
implements Comparable<FunnelStepEvent> {
    public static final int SIZE_IN_BYTES = 12;
    private final long _timestamp;
    private final int _step;

    public FunnelStepEvent(long timestamp, int step) {
        this._timestamp = timestamp;
        this._step = step;
    }

    public FunnelStepEvent(byte[] bytes) {
        try (DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(bytes));){
            this._timestamp = dataInputStream.readLong();
            this._step = dataInputStream.readInt();
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while converting byte[] to FunnelStepEvent", e);
        }
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public int getStep() {
        return this._step;
    }

    public String toString() {
        return "StepEvent{timestamp=" + this._timestamp + ", step=" + this._step + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunnelStepEvent stepEvent = (FunnelStepEvent)o;
        if (this._timestamp != stepEvent._timestamp) {
            return false;
        }
        return this._step == stepEvent._step;
    }

    public int hashCode() {
        int result = Long.hashCode(this._timestamp);
        result = 31 * result + this._step;
        return result;
    }

    @Override
    public int compareTo(FunnelStepEvent o) {
        if (this._timestamp < o._timestamp) {
            return -1;
        }
        if (this._timestamp > o._timestamp) {
            return 1;
        }
        return Integer.compare(this._step, o._step);
    }

    public byte[] getBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(this._timestamp);
            dataOutputStream.writeInt(this._step);
            dataOutputStream.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while converting FunnelStepEvent to byte[]", e);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

