/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.funnel;

import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.pinot.core.query.aggregation.function.funnel.DictIdsWrapper;
import org.apache.pinot.core.query.aggregation.function.funnel.ResultExtractionStrategy;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

class SetResultExtractionStrategy
implements ResultExtractionStrategy<DictIdsWrapper, List<Set>> {
    protected final int _numSteps;

    SetResultExtractionStrategy(int numSteps) {
        this._numSteps = numSteps;
    }

    @Override
    public List<Set> extractIntermediateResult(DictIdsWrapper dictIdsWrapper) {
        Dictionary dictionary = dictIdsWrapper._dictionary;
        ArrayList<Set> result = new ArrayList<Set>(this._numSteps);
        for (RoaringBitmap dictIdBitmap : dictIdsWrapper._stepsBitmaps) {
            result.add(this.convertToValueSet(dictionary, dictIdBitmap));
        }
        return result;
    }

    private Set convertToValueSet(Dictionary dictionary, RoaringBitmap dictIdBitmap) {
        int numValues = dictIdBitmap.getCardinality();
        PeekableIntIterator iterator = dictIdBitmap.getIntIterator();
        FieldSpec.DataType storedType = dictionary.getValueType();
        switch (storedType) {
            case INT: {
                IntOpenHashSet intSet = new IntOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    intSet.add(dictionary.getIntValue(iterator.next()));
                }
                return intSet;
            }
            case LONG: {
                LongOpenHashSet longSet = new LongOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    longSet.add(dictionary.getLongValue(iterator.next()));
                }
                return longSet;
            }
            case FLOAT: {
                FloatOpenHashSet floatSet = new FloatOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    floatSet.add(dictionary.getFloatValue(iterator.next()));
                }
                return floatSet;
            }
            case DOUBLE: {
                DoubleOpenHashSet doubleSet = new DoubleOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    doubleSet.add(dictionary.getDoubleValue(iterator.next()));
                }
                return doubleSet;
            }
            case STRING: {
                ObjectOpenHashSet stringSet = new ObjectOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    stringSet.add((Object)dictionary.getStringValue(iterator.next()));
                }
                return stringSet;
            }
        }
        throw new IllegalArgumentException("Illegal data type for FUNNEL_COUNT aggregation function: " + storedType);
    }
}

