/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.funnel;

import java.util.List;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.query.aggregation.function.funnel.AggregationStrategy;
import org.apache.pinot.segment.spi.index.reader.Dictionary;

class ThetaSketchAggregationStrategy
extends AggregationStrategy<UpdateSketch[]> {
    final UpdateSketchBuilder _updateSketchBuilder;

    public ThetaSketchAggregationStrategy(List<ExpressionContext> stepExpressions, List<ExpressionContext> correlateByExpressions, int nominalEntries) {
        super(stepExpressions, correlateByExpressions);
        this._updateSketchBuilder = new UpdateSketchBuilder().setNominalEntries(nominalEntries);
    }

    @Override
    public UpdateSketch[] createAggregationResult(Dictionary dictionary) {
        UpdateSketch[] stepsSketches = new UpdateSketch[this._numSteps];
        for (int n = 0; n < this._numSteps; ++n) {
            stepsSketches[n] = this._updateSketchBuilder.build();
        }
        return stepsSketches;
    }

    @Override
    void add(Dictionary dictionary, UpdateSketch[] stepsSketches, int step, int correlationId) {
        UpdateSketch sketch = stepsSketches[step];
        switch (dictionary.getValueType()) {
            case INT: {
                sketch.update((long)dictionary.getIntValue(correlationId));
                break;
            }
            case LONG: {
                sketch.update(dictionary.getLongValue(correlationId));
                break;
            }
            case FLOAT: {
                sketch.update((double)dictionary.getFloatValue(correlationId));
                break;
            }
            case DOUBLE: {
                sketch.update(dictionary.getDoubleValue(correlationId));
                break;
            }
            case STRING: {
                sketch.update(dictionary.getStringValue(correlationId));
                break;
            }
            default: {
                throw new IllegalStateException("Illegal CORRELATED_BY column data type for FUNNEL_COUNT aggregation function: " + dictionary.getValueType());
            }
        }
    }
}

