/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.funnel.window;

import java.util.ArrayDeque;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.aggregation.function.funnel.FunnelStepEvent;
import org.apache.pinot.core.query.aggregation.function.funnel.window.FunnelBaseAggregationFunction;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class FunnelCompleteCountAggregationFunction
extends FunnelBaseAggregationFunction<Integer> {
    public FunnelCompleteCountAggregationFunction(List<ExpressionContext> arguments) {
        super(arguments);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.FUNNELCOMPLETECOUNT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.INT;
    }

    @Override
    public Integer extractFinalResult(PriorityQueue<FunnelStepEvent> stepEvents) {
        int totalCompletedRounds = 0;
        if (stepEvents == null || stepEvents.isEmpty()) {
            return totalCompletedRounds;
        }
        ArrayDeque<FunnelStepEvent> slidingWindow = new ArrayDeque<FunnelStepEvent>();
        while (!stepEvents.isEmpty()) {
            this.fillWindow(stepEvents, slidingWindow);
            if (slidingWindow.isEmpty()) break;
            long windowStart = slidingWindow.peek().getTimestamp();
            int maxStep = 0;
            long previousTimestamp = -1L;
            for (FunnelStepEvent event : slidingWindow) {
                int currentEventStep = event.getStep();
                if (this._modes.hasStrictDeduplication() && currentEventStep == maxStep - 1) {
                    maxStep = 0;
                }
                if (this._modes.hasStrictOrder() && currentEventStep != maxStep) {
                    maxStep = 0;
                }
                if (this._modes.hasStrictIncrease() && previousTimestamp == event.getTimestamp()) continue;
                previousTimestamp = event.getTimestamp();
                if (maxStep == currentEventStep) {
                    ++maxStep;
                }
                if (maxStep != this._numSteps) continue;
                ++totalCompletedRounds;
                maxStep = 0;
                windowStart = event.getTimestamp();
            }
            if (!slidingWindow.isEmpty()) {
                slidingWindow.pollFirst();
            }
            while (!slidingWindow.isEmpty() && slidingWindow.peek().getTimestamp() < windowStart) {
                slidingWindow.pollFirst();
            }
        }
        return totalCompletedRounds;
    }

    @Override
    public Integer mergeFinalResult(Integer finalResult1, Integer finalResult2) {
        return finalResult1 + finalResult2;
    }
}

