/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.funnel.window;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayDeque;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.aggregation.function.funnel.FunnelStepEvent;
import org.apache.pinot.core.query.aggregation.function.funnel.window.FunnelBaseAggregationFunction;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class FunnelMatchStepAggregationFunction
extends FunnelBaseAggregationFunction<IntArrayList> {
    public FunnelMatchStepAggregationFunction(List<ExpressionContext> arguments) {
        super(arguments);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.FUNNELMATCHSTEP;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.INT_ARRAY;
    }

    @Override
    public IntArrayList extractFinalResult(PriorityQueue<FunnelStepEvent> stepEvents) {
        int finalMaxStep = 0;
        IntArrayList result = new IntArrayList(this._numSteps);
        for (int i = 0; i < this._numSteps; ++i) {
            result.add(0);
        }
        if (stepEvents == null || stepEvents.isEmpty()) {
            return result;
        }
        ArrayDeque<FunnelStepEvent> slidingWindow = new ArrayDeque<FunnelStepEvent>();
        while (!stepEvents.isEmpty()) {
            int maxSteps;
            this.fillWindow(stepEvents, slidingWindow);
            if (slidingWindow.isEmpty() || (finalMaxStep = Math.max(finalMaxStep, maxSteps = this.processWindow(slidingWindow).intValue())) == this._numSteps) break;
            if (slidingWindow.isEmpty()) continue;
            slidingWindow.pollFirst();
        }
        for (int i = 0; i < finalMaxStep; ++i) {
            result.set(i, 1);
        }
        return result;
    }

    protected Integer processWindow(ArrayDeque<FunnelStepEvent> slidingWindow) {
        int maxStep = 0;
        long previousTimestamp = -1L;
        for (FunnelStepEvent event : slidingWindow) {
            int currentEventStep = event.getStep();
            if (this._modes.hasStrictDeduplication() && currentEventStep == maxStep - 1) {
                return maxStep;
            }
            if (this._modes.hasStrictOrder() && currentEventStep != maxStep) {
                return maxStep;
            }
            if (this._modes.hasStrictIncrease() && previousTimestamp == event.getTimestamp()) continue;
            if (maxStep == currentEventStep) {
                ++maxStep;
                previousTimestamp = event.getTimestamp();
            }
            if (maxStep != this._numSteps) continue;
            break;
        }
        return maxStep;
    }

    @Override
    public IntArrayList mergeFinalResult(IntArrayList finalResult1, IntArrayList finalResult2) {
        for (int i = 0; i < this._numSteps; ++i) {
            if (finalResult1.getInt(i) == 0) {
                return finalResult2;
            }
            if (finalResult2.getInt(i) != 0) continue;
            return finalResult1;
        }
        return finalResult1;
    }
}

