/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.data.table.IntermediateRecord;
import org.apache.pinot.core.data.table.TableResizer;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.core.query.aggregation.groupby.DictionaryBasedGroupKeyGenerator;
import org.apache.pinot.core.query.aggregation.groupby.GroupByExecutor;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.core.query.aggregation.groupby.NoDictionaryMultiColumnGroupKeyGenerator;
import org.apache.pinot.core.query.aggregation.groupby.NoDictionarySingleColumnGroupKeyGenerator;
import org.apache.pinot.core.query.request.context.QueryContext;

public class DefaultGroupByExecutor
implements GroupByExecutor {
    private static final ThreadLocal<int[]> THREAD_LOCAL_SV_GROUP_KEYS = ThreadLocal.withInitial(() -> new int[10000]);
    private static final ThreadLocal<int[][]> THREAD_LOCAL_MV_GROUP_KEYS = ThreadLocal.withInitial(() -> new int[10000][]);
    protected final AggregationFunction[] _aggregationFunctions;
    protected final boolean _nullHandlingEnabled;
    protected final GroupKeyGenerator _groupKeyGenerator;
    protected final GroupByResultHolder[] _groupByResultHolders;
    protected final boolean _hasMVGroupByExpression;
    protected final int[] _svGroupKeys;
    protected final int[][] _mvGroupKeys;

    public DefaultGroupByExecutor(QueryContext queryContext, ExpressionContext[] groupByExpressions, BaseProjectOperator<?> projectOperator) {
        this(queryContext, queryContext.getAggregationFunctions(), groupByExpressions, projectOperator, null);
    }

    public DefaultGroupByExecutor(QueryContext queryContext, AggregationFunction[] aggregationFunctions, ExpressionContext[] groupByExpressions, BaseProjectOperator<?> projectOperator) {
        this(queryContext, aggregationFunctions, groupByExpressions, projectOperator, null);
    }

    public DefaultGroupByExecutor(QueryContext queryContext, AggregationFunction[] aggregationFunctions, ExpressionContext[] groupByExpressions, BaseProjectOperator<?> projectOperator, @Nullable GroupKeyGenerator groupKeyGenerator) {
        this._aggregationFunctions = aggregationFunctions;
        assert (this._aggregationFunctions != null);
        this._nullHandlingEnabled = queryContext.isNullHandlingEnabled();
        boolean hasMVGroupByExpression = false;
        boolean hasNoDictionaryGroupByExpression = false;
        for (ExpressionContext groupByExpression : groupByExpressions) {
            ColumnContext columnContext = projectOperator.getResultColumnContext(groupByExpression);
            hasMVGroupByExpression |= !columnContext.isSingleValue();
            hasNoDictionaryGroupByExpression |= columnContext.getDictionary() == null;
        }
        this._hasMVGroupByExpression = hasMVGroupByExpression;
        int numGroupsLimit = queryContext.getNumGroupsLimit();
        int maxInitialResultHolderCapacity = queryContext.getMaxInitialResultHolderCapacity();
        this._groupKeyGenerator = groupKeyGenerator != null ? groupKeyGenerator : (hasNoDictionaryGroupByExpression || this._nullHandlingEnabled ? (groupByExpressions.length == 1 ? new NoDictionarySingleColumnGroupKeyGenerator(projectOperator, groupByExpressions[0], numGroupsLimit, this._nullHandlingEnabled) : new NoDictionaryMultiColumnGroupKeyGenerator(projectOperator, groupByExpressions, numGroupsLimit, this._nullHandlingEnabled)) : new DictionaryBasedGroupKeyGenerator(projectOperator, groupByExpressions, numGroupsLimit, maxInitialResultHolderCapacity));
        int maxNumResults = this._groupKeyGenerator.getGlobalGroupKeyUpperBound();
        int initialCapacity = Math.min(maxNumResults, maxInitialResultHolderCapacity);
        int numAggregationFunctions = this._aggregationFunctions.length;
        this._groupByResultHolders = new GroupByResultHolder[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            this._groupByResultHolders[i] = this._aggregationFunctions[i].createGroupByResultHolder(initialCapacity, maxNumResults);
        }
        if (this._hasMVGroupByExpression) {
            this._svGroupKeys = null;
            this._mvGroupKeys = THREAD_LOCAL_MV_GROUP_KEYS.get();
        } else {
            this._svGroupKeys = THREAD_LOCAL_SV_GROUP_KEYS.get();
            this._mvGroupKeys = null;
        }
    }

    @Override
    public void process(ValueBlock valueBlock) {
        if (this._hasMVGroupByExpression) {
            this._groupKeyGenerator.generateKeysForBlock(valueBlock, this._mvGroupKeys);
        } else {
            this._groupKeyGenerator.generateKeysForBlock(valueBlock, this._svGroupKeys);
        }
        int capacityNeeded = this._groupKeyGenerator.getCurrentGroupKeyUpperBound();
        int length = valueBlock.getNumDocs();
        int numAggregationFunctions = this._aggregationFunctions.length;
        for (int i = 0; i < numAggregationFunctions; ++i) {
            GroupByResultHolder groupByResultHolder = this._groupByResultHolders[i];
            groupByResultHolder.ensureCapacity(capacityNeeded);
            this.aggregate(valueBlock, length, i);
        }
    }

    protected void aggregate(ValueBlock valueBlock, int length, int functionIndex) {
        AggregationFunction aggregationFunction = this._aggregationFunctions[functionIndex];
        Map<ExpressionContext, BlockValSet> blockValSetMap = AggregationFunctionUtils.getBlockValSetMap(aggregationFunction, valueBlock);
        GroupByResultHolder groupByResultHolder = this._groupByResultHolders[functionIndex];
        if (this._hasMVGroupByExpression) {
            aggregationFunction.aggregateGroupByMV(length, this._mvGroupKeys, groupByResultHolder, blockValSetMap);
        } else {
            aggregationFunction.aggregateGroupBySV(length, this._svGroupKeys, groupByResultHolder, blockValSetMap);
        }
    }

    @Override
    public AggregationGroupByResult getResult() {
        return new AggregationGroupByResult(this._groupKeyGenerator, this._aggregationFunctions, this._groupByResultHolders);
    }

    @Override
    public int getNumGroups() {
        return this._groupKeyGenerator.getNumKeys();
    }

    @Override
    public Collection<IntermediateRecord> trimGroupByResult(int trimSize, TableResizer tableResizer) {
        return tableResizer.trimInSegmentResults(this._groupKeyGenerator, this._groupByResultHolders, trimSize);
    }

    @Override
    public GroupKeyGenerator getGroupKeyGenerator() {
        return this._groupKeyGenerator;
    }

    @Override
    public GroupByResultHolder[] getGroupByResultHolders() {
        return this._groupByResultHolders;
    }
}

