/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.segment.spi.index.reader.Dictionary;

public class DictionaryBasedGroupKeyGenerator
implements GroupKeyGenerator {
    private static final int INITIAL_MAP_SIZE = 384;
    private static final int MAX_CACHING_MAP_SIZE = 786432;
    private static final int MAX_DICTIONARY_INTERN_TABLE_SIZE = 10000;
    @VisibleForTesting
    static final ThreadLocal<IntGroupIdMap> THREAD_LOCAL_INT_MAP = ThreadLocal.withInitial(IntGroupIdMap::new);
    @VisibleForTesting
    static final ThreadLocal<Long2IntOpenHashMap> THREAD_LOCAL_LONG_MAP = ThreadLocal.withInitial(() -> {
        Long2IntOpenHashMap map = new Long2IntOpenHashMap(384);
        map.defaultReturnValue(-1);
        return map;
    });
    @VisibleForTesting
    static final ThreadLocal<Object2IntOpenHashMap<IntArray>> THREAD_LOCAL_INT_ARRAY_MAP = ThreadLocal.withInitial(() -> {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap(384);
        map.defaultReturnValue(-1);
        return map;
    });
    private final ExpressionContext[] _groupByExpressions;
    private final int _numGroupByExpressions;
    private final int[] _cardinalities;
    private final boolean[] _isSingleValueColumn;
    private final Dictionary[] _dictionaries;
    private final int[][] _singleValueDictIds;
    private final int[][][] _multiValueDictIds;
    private final Object[][] _internedDictionaryValues;
    private final int _globalGroupIdUpperBound;
    private final RawKeyHolder _rawKeyHolder;

    public DictionaryBasedGroupKeyGenerator(BaseProjectOperator<?> projectOperator, ExpressionContext[] groupByExpressions, int numGroupsLimit, int arrayBasedThreshold) {
        assert (numGroupsLimit >= arrayBasedThreshold);
        this._groupByExpressions = groupByExpressions;
        this._numGroupByExpressions = groupByExpressions.length;
        this._cardinalities = new int[this._numGroupByExpressions];
        this._isSingleValueColumn = new boolean[this._numGroupByExpressions];
        this._dictionaries = new Dictionary[this._numGroupByExpressions];
        this._singleValueDictIds = new int[this._numGroupByExpressions][];
        this._multiValueDictIds = new int[this._numGroupByExpressions][][];
        this._internedDictionaryValues = this._numGroupByExpressions > 1 ? new Object[this._numGroupByExpressions][] : null;
        long cardinalityProduct = 1L;
        boolean longOverflow = false;
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            int cardinality;
            ExpressionContext groupByExpression = groupByExpressions[i];
            ColumnContext columnContext = projectOperator.getResultColumnContext(groupByExpression);
            this._dictionaries[i] = columnContext.getDictionary();
            assert (this._dictionaries[i] != null);
            this._cardinalities[i] = cardinality = this._dictionaries[i].length();
            if (this._internedDictionaryValues != null && cardinality < 10000) {
                this._internedDictionaryValues[i] = new Object[cardinality];
            }
            if (!longOverflow) {
                if (cardinalityProduct > Long.MAX_VALUE / (long)cardinality) {
                    longOverflow = true;
                } else {
                    cardinalityProduct *= (long)cardinality;
                }
            }
            this._isSingleValueColumn[i] = columnContext.isSingleValue();
        }
        if (longOverflow) {
            this._globalGroupIdUpperBound = numGroupsLimit;
            Object2IntOpenHashMap<IntArray> groupIdMap = THREAD_LOCAL_INT_ARRAY_MAP.get();
            int size = groupIdMap.size();
            groupIdMap.clear();
            if (size > 786432) {
                groupIdMap.trim();
            }
            this._rawKeyHolder = new ArrayMapBasedHolder(groupIdMap);
        } else if (cardinalityProduct > Integer.MAX_VALUE) {
            this._globalGroupIdUpperBound = numGroupsLimit;
            Long2IntOpenHashMap groupIdMap = THREAD_LOCAL_LONG_MAP.get();
            int size = groupIdMap.size();
            groupIdMap.clear();
            if (size > 786432) {
                groupIdMap.trim();
            }
            this._rawKeyHolder = new LongMapBasedHolder(groupIdMap);
        } else {
            this._globalGroupIdUpperBound = Math.min((int)cardinalityProduct, numGroupsLimit);
            if (cardinalityProduct > (long)arrayBasedThreshold) {
                IntGroupIdMap groupIdMap = THREAD_LOCAL_INT_MAP.get();
                groupIdMap.clearAndTrim();
                this._rawKeyHolder = new IntMapBasedHolder(groupIdMap);
            } else {
                this._rawKeyHolder = new ArrayBasedHolder();
            }
        }
    }

    @Override
    public int getGlobalGroupKeyUpperBound() {
        return this._globalGroupIdUpperBound;
    }

    @Override
    public void generateKeysForBlock(ValueBlock valueBlock, int[] groupKeys) {
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            BlockValSet blockValueSet = valueBlock.getBlockValueSet(this._groupByExpressions[i]);
            this._singleValueDictIds[i] = blockValueSet.getDictionaryIdsSV();
        }
        this._rawKeyHolder.processSingleValue(valueBlock.getNumDocs(), groupKeys);
    }

    @Override
    public void generateKeysForBlock(ValueBlock valueBlock, int[][] groupKeys) {
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            BlockValSet blockValueSet = valueBlock.getBlockValueSet(this._groupByExpressions[i]);
            if (this._isSingleValueColumn[i]) {
                this._singleValueDictIds[i] = blockValueSet.getDictionaryIdsSV();
                continue;
            }
            this._multiValueDictIds[i] = blockValueSet.getDictionaryIdsMV();
        }
        this._rawKeyHolder.processMultiValue(valueBlock.getNumDocs(), groupKeys);
    }

    @Override
    public int getCurrentGroupKeyUpperBound() {
        return this._rawKeyHolder.getGroupIdUpperBound();
    }

    @Override
    public Iterator<GroupKeyGenerator.GroupKey> getGroupKeys() {
        return this._rawKeyHolder.getGroupKeys();
    }

    @Override
    public int getNumKeys() {
        return this._rawKeyHolder.getNumKeys();
    }

    private int[] getIntRawKeys(int index) {
        int[] rawKeys = null;
        if (this._numGroupByExpressions == 1) {
            rawKeys = this._multiValueDictIds[0][index];
        } else {
            int rawKey = 0;
            for (int i = this._numGroupByExpressions - 1; i >= 0; --i) {
                int j;
                int cardinality = this._cardinalities[i];
                if (this._isSingleValueColumn[i]) {
                    int dictId = this._singleValueDictIds[i][index];
                    if (rawKeys == null) {
                        rawKey = rawKey * cardinality + dictId;
                        continue;
                    }
                    int length = rawKeys.length;
                    for (j = 0; j < length; ++j) {
                        rawKeys[j] = rawKeys[j] * cardinality + dictId;
                    }
                    continue;
                }
                int[] multiValueDictIds = this._multiValueDictIds[i][index];
                int numValues = multiValueDictIds.length;
                if (numValues == 1) {
                    int dictId = multiValueDictIds[0];
                    if (rawKeys == null) {
                        rawKey = rawKey * cardinality + dictId;
                        continue;
                    }
                    int length = rawKeys.length;
                    for (int j2 = 0; j2 < length; ++j2) {
                        rawKeys[j2] = rawKeys[j2] * cardinality + dictId;
                    }
                    continue;
                }
                if (rawKeys == null) {
                    rawKeys = new int[numValues];
                    for (j = 0; j < numValues; ++j) {
                        int dictId = multiValueDictIds[j];
                        rawKeys[j] = rawKey * cardinality + dictId;
                    }
                    continue;
                }
                int currentLength = rawKeys.length;
                int newLength = currentLength * numValues;
                int[] newRawKeys = new int[newLength];
                for (int j3 = 0; j3 < numValues; ++j3) {
                    int startOffset = j3 * currentLength;
                    System.arraycopy(rawKeys, 0, newRawKeys, startOffset, currentLength);
                    int dictId = multiValueDictIds[j3];
                    int endOffset = startOffset + currentLength;
                    for (int k = startOffset; k < endOffset; ++k) {
                        newRawKeys[k] = newRawKeys[k] * cardinality + dictId;
                    }
                }
                rawKeys = newRawKeys;
            }
            if (rawKeys == null) {
                rawKeys = new int[]{rawKey};
            }
        }
        return rawKeys;
    }

    private Object[] getKeys(int rawKey) {
        if (this._numGroupByExpressions == 1) {
            return new Object[]{this._dictionaries[0].getInternal(rawKey)};
        }
        Object[] groupKeys = new Object[this._numGroupByExpressions];
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            int cardinality = this._cardinalities[i];
            groupKeys[i] = this.getRawValue(i, rawKey % cardinality);
            rawKey /= cardinality;
        }
        return groupKeys;
    }

    private Object getRawValue(int dictionaryIndex, int dictId) {
        Dictionary dictionary = this._dictionaries[dictionaryIndex];
        Object[] table = this._internedDictionaryValues[dictionaryIndex];
        if (table == null) {
            return dictionary.getInternal(dictId);
        }
        Object rawValue = table[dictId];
        if (rawValue == null) {
            table[dictId] = rawValue = dictionary.getInternal(dictId);
        }
        return rawValue;
    }

    private String getStringKey(int rawKey) {
        if (this._numGroupByExpressions == 1) {
            return this._dictionaries[0].getStringValue(rawKey);
        }
        int cardinality = this._cardinalities[0];
        StringBuilder groupKeyBuilder = new StringBuilder(this._dictionaries[0].getStringValue(rawKey % cardinality));
        rawKey /= cardinality;
        for (int i = 1; i < this._numGroupByExpressions; ++i) {
            groupKeyBuilder.append('\u0000');
            cardinality = this._cardinalities[i];
            groupKeyBuilder.append(this._dictionaries[i].getStringValue(rawKey % cardinality));
            rawKey /= cardinality;
        }
        return groupKeyBuilder.toString();
    }

    private long[] getLongRawKeys(int index) {
        long[] rawKeys = null;
        long rawKey = 0L;
        for (int i = this._numGroupByExpressions - 1; i >= 0; --i) {
            int j;
            int cardinality = this._cardinalities[i];
            if (this._isSingleValueColumn[i]) {
                int dictId = this._singleValueDictIds[i][index];
                if (rawKeys == null) {
                    rawKey = rawKey * (long)cardinality + (long)dictId;
                    continue;
                }
                int length = rawKeys.length;
                for (j = 0; j < length; ++j) {
                    rawKeys[j] = rawKeys[j] * (long)cardinality + (long)dictId;
                }
                continue;
            }
            int[] multiValueDictIds = this._multiValueDictIds[i][index];
            int numValues = multiValueDictIds.length;
            if (numValues == 1) {
                int dictId = multiValueDictIds[0];
                if (rawKeys == null) {
                    rawKey = rawKey * (long)cardinality + (long)dictId;
                    continue;
                }
                int length = rawKeys.length;
                for (int j2 = 0; j2 < length; ++j2) {
                    rawKeys[j2] = rawKeys[j2] * (long)cardinality + (long)dictId;
                }
                continue;
            }
            if (rawKeys == null) {
                rawKeys = new long[numValues];
                for (j = 0; j < numValues; ++j) {
                    int dictId = multiValueDictIds[j];
                    rawKeys[j] = rawKey * (long)cardinality + (long)dictId;
                }
                continue;
            }
            int currentLength = rawKeys.length;
            int newLength = currentLength * numValues;
            long[] newRawKeys = new long[newLength];
            for (int j3 = 0; j3 < numValues; ++j3) {
                int startOffset = j3 * currentLength;
                System.arraycopy(rawKeys, 0, newRawKeys, startOffset, currentLength);
                int dictId = multiValueDictIds[j3];
                int endOffset = startOffset + currentLength;
                for (int k = startOffset; k < endOffset; ++k) {
                    newRawKeys[k] = newRawKeys[k] * (long)cardinality + (long)dictId;
                }
            }
            rawKeys = newRawKeys;
        }
        if (rawKeys == null) {
            return new long[]{rawKey};
        }
        return rawKeys;
    }

    private Object[] getKeys(long rawKey) {
        Object[] groupKeys = new Object[this._numGroupByExpressions];
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            int cardinality = this._cardinalities[i];
            groupKeys[i] = this.getRawValue(i, (int)(rawKey % (long)cardinality));
            rawKey /= (long)cardinality;
        }
        return groupKeys;
    }

    private String getStringKey(long rawKey) {
        int cardinality = this._cardinalities[0];
        StringBuilder groupKeyBuilder = new StringBuilder(this._dictionaries[0].getStringValue((int)(rawKey % (long)cardinality)));
        rawKey /= (long)cardinality;
        for (int i = 1; i < this._numGroupByExpressions; ++i) {
            groupKeyBuilder.append('\u0000');
            cardinality = this._cardinalities[i];
            groupKeyBuilder.append(this._dictionaries[i].getStringValue((int)(rawKey % (long)cardinality)));
            rawKey /= (long)cardinality;
        }
        return groupKeyBuilder.toString();
    }

    private IntArray[] getIntArrayRawKeys(int index) {
        IntArray[] rawKeys = null;
        int[] dictIds = new int[this._numGroupByExpressions];
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            int j;
            if (this._isSingleValueColumn[i]) {
                int dictId = this._singleValueDictIds[i][index];
                if (rawKeys == null) {
                    dictIds[i] = dictId;
                    continue;
                }
                for (IntArray rawKey : rawKeys) {
                    rawKey._elements[i] = dictId;
                }
                continue;
            }
            int[] multiValueDictIds = this._multiValueDictIds[i][index];
            int numValues = multiValueDictIds.length;
            if (numValues == 1) {
                int dictId = multiValueDictIds[0];
                if (rawKeys == null) {
                    dictIds[i] = dictId;
                    continue;
                }
                for (IntArray rawKey : rawKeys) {
                    rawKey._elements[i] = dictId;
                }
                continue;
            }
            if (rawKeys == null) {
                rawKeys = new IntArray[numValues];
                for (int j2 = 0; j2 < numValues; ++j2) {
                    int dictId = multiValueDictIds[j2];
                    rawKeys[j2] = new IntArray((int[])dictIds.clone());
                    rawKeys[j2]._elements[i] = dictId;
                }
                continue;
            }
            int currentLength = rawKeys.length;
            int newLength = currentLength * numValues;
            IntArray[] newRawKeys = new IntArray[newLength];
            System.arraycopy(rawKeys, 0, newRawKeys, 0, currentLength);
            for (j = 1; j < numValues; ++j) {
                int offset = j * currentLength;
                for (int k = 0; k < currentLength; ++k) {
                    newRawKeys[offset + k] = new IntArray((int[])rawKeys[k]._elements.clone());
                }
            }
            for (j = 0; j < numValues; ++j) {
                int startOffset = j * currentLength;
                int dictId = multiValueDictIds[j];
                int endOffset = startOffset + currentLength;
                for (int k = startOffset; k < endOffset; ++k) {
                    newRawKeys[k]._elements[i] = dictId;
                }
            }
            rawKeys = newRawKeys;
        }
        if (rawKeys == null) {
            return new IntArray[]{new IntArray(dictIds)};
        }
        return rawKeys;
    }

    private Object[] getKeys(IntArray rawKey) {
        Object[] groupKeys = new Object[this._numGroupByExpressions];
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            groupKeys[i] = this.getRawValue(i, rawKey._elements[i]);
        }
        return groupKeys;
    }

    private String getStringKey(IntArray rawKey) {
        StringBuilder groupKeyBuilder = new StringBuilder(this._dictionaries[0].getStringValue(rawKey._elements[0]));
        for (int i = 1; i < this._numGroupByExpressions; ++i) {
            groupKeyBuilder.append('\u0000');
            groupKeyBuilder.append(this._dictionaries[i].getStringValue(rawKey._elements[i]));
        }
        return groupKeyBuilder.toString();
    }

    @VisibleForTesting
    static class IntArray {
        public int[] _elements;

        public IntArray(int[] elements) {
            this._elements = elements;
        }

        public int hashCode() {
            int result = 1;
            for (int element : this._elements) {
                result = 31 * result + element;
            }
            return result;
        }

        public boolean equals(Object obj) {
            int length = this._elements.length;
            int[] that = ((IntArray)obj)._elements;
            if (length != that.length) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (this._elements[i] == that[i]) continue;
                return false;
            }
            return true;
        }
    }

    @VisibleForTesting
    public static class IntGroupIdMap {
        private static final float LOAD_FACTOR = 0.75f;
        private int[] _keyValueHolder;
        private int _capacity;
        private int _mask;
        private int _maxNumEntries;
        private int _size;

        public IntGroupIdMap() {
            this.init();
        }

        private void init() {
            this._capacity = 512;
            int holderSize = this._capacity << 1;
            this._keyValueHolder = new int[holderSize];
            this._mask = holderSize - 1;
            this._maxNumEntries = (int)((float)this._capacity * 0.75f);
        }

        public int size() {
            return this._size;
        }

        public int getGroupId(int rawKey, int groupIdUpperBound) {
            int internalKey = rawKey + 1;
            int index = HashCommon.mix((int)internalKey) << 1 & this._mask;
            int key = this._keyValueHolder[index];
            if (key == internalKey) {
                return this._keyValueHolder[index + 1];
            }
            if (key == 0) {
                return this._size < groupIdUpperBound ? this.addNewGroup(internalKey, index) : -1;
            }
            do {
                if ((key = this._keyValueHolder[index = index + 2 & this._mask]) != internalKey) continue;
                return this._keyValueHolder[index + 1];
            } while (key != 0);
            return this._size < groupIdUpperBound ? this.addNewGroup(internalKey, index) : -1;
        }

        private int addNewGroup(int internalKey, int index) {
            int groupId = this._size++;
            this._keyValueHolder[index] = internalKey;
            this._keyValueHolder[index + 1] = groupId;
            if (this._size > this._maxNumEntries) {
                this.expand();
            }
            return groupId;
        }

        private void expand() {
            this._capacity <<= 1;
            int holderSize = this._capacity << 1;
            int[] oldKeyValueHolder = this._keyValueHolder;
            this._keyValueHolder = new int[holderSize];
            this._mask = holderSize - 1;
            this._maxNumEntries <<= 1;
            int oldIndex = 0;
            for (int i = 0; i < this._size; ++i) {
                while (oldKeyValueHolder[oldIndex] == 0) {
                    oldIndex += 2;
                }
                int key = oldKeyValueHolder[oldIndex];
                int value = oldKeyValueHolder[oldIndex + 1];
                int newIndex = HashCommon.mix((int)key) << 1 & this._mask;
                if (this._keyValueHolder[newIndex] != 0) {
                    while (this._keyValueHolder[newIndex = newIndex + 2 & this._mask] != 0) {
                    }
                }
                this._keyValueHolder[newIndex] = key;
                this._keyValueHolder[newIndex + 1] = value;
                oldIndex += 2;
            }
        }

        public Iterator<Entry> iterator() {
            return new Iterator<Entry>(){
                private final Entry _entry = new Entry();
                private int _index;
                private int _numRemainingEntries;
                {
                    this._numRemainingEntries = _size;
                }

                @Override
                public boolean hasNext() {
                    return this._numRemainingEntries > 0;
                }

                @Override
                public Entry next() {
                    int key;
                    while ((key = _keyValueHolder[this._index]) == 0) {
                        this._index += 2;
                    }
                    this._entry._rawKey = key - 1;
                    this._entry._groupId = _keyValueHolder[this._index + 1];
                    this._index += 2;
                    --this._numRemainingEntries;
                    return this._entry;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public void clearAndTrim() {
            if (this._size == 0) {
                return;
            }
            if (this._size <= 786432) {
                Arrays.fill(this._keyValueHolder, 0);
            } else {
                this.init();
            }
            this._size = 0;
        }

        public static class Entry {
            public int _rawKey;
            public int _groupId;
        }
    }

    private class ArrayMapBasedHolder
    implements RawKeyHolder {
        private final Object2IntOpenHashMap<IntArray> _groupIdMap;

        public ArrayMapBasedHolder(Object2IntOpenHashMap<IntArray> groupIdMap) {
            this._groupIdMap = groupIdMap;
        }

        @Override
        public void processSingleValue(int numDocs, int[] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                int[] dictIds = new int[DictionaryBasedGroupKeyGenerator.this._numGroupByExpressions];
                for (int j = 0; j < DictionaryBasedGroupKeyGenerator.this._numGroupByExpressions; ++j) {
                    dictIds[j] = DictionaryBasedGroupKeyGenerator.this._singleValueDictIds[j][i];
                }
                outGroupIds[i] = this.getGroupId(new IntArray(dictIds));
            }
        }

        @Override
        public void processMultiValue(int numDocs, int[][] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                IntArray[] rawKeys = DictionaryBasedGroupKeyGenerator.this.getIntArrayRawKeys(i);
                int length = rawKeys.length;
                int[] groupIds = new int[length];
                for (int j = 0; j < length; ++j) {
                    groupIds[j] = this.getGroupId(rawKeys[j]);
                }
                outGroupIds[i] = groupIds;
            }
        }

        private int getGroupId(IntArray rawKey) {
            int numGroups = this._groupIdMap.size();
            if (numGroups < DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound) {
                return this._groupIdMap.computeIntIfAbsent((Object)rawKey, k -> numGroups);
            }
            return this._groupIdMap.getInt((Object)rawKey);
        }

        @Override
        public int getGroupIdUpperBound() {
            return this._groupIdMap.size();
        }

        @Override
        public Iterator<GroupKeyGenerator.GroupKey> getGroupKeys() {
            return new Iterator<GroupKeyGenerator.GroupKey>(){
                private final ObjectIterator<Object2IntMap.Entry<IntArray>> _iterator;
                private final GroupKeyGenerator.GroupKey _groupKey;
                {
                    this._iterator = ArrayMapBasedHolder.this._groupIdMap.object2IntEntrySet().fastIterator();
                    this._groupKey = new GroupKeyGenerator.GroupKey();
                }

                @Override
                public boolean hasNext() {
                    return this._iterator.hasNext();
                }

                @Override
                public GroupKeyGenerator.GroupKey next() {
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)this._iterator.next();
                    this._groupKey._groupId = entry.getIntValue();
                    this._groupKey._keys = DictionaryBasedGroupKeyGenerator.this.getKeys((IntArray)entry.getKey());
                    return this._groupKey;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int getNumKeys() {
            return this._groupIdMap.size();
        }
    }

    private class LongMapBasedHolder
    implements RawKeyHolder {
        private final Long2IntOpenHashMap _groupIdMap;

        public LongMapBasedHolder(Long2IntOpenHashMap groupIdMap) {
            this._groupIdMap = groupIdMap;
        }

        @Override
        public void processSingleValue(int numDocs, int[] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                long rawKey = 0L;
                for (int j = DictionaryBasedGroupKeyGenerator.this._numGroupByExpressions - 1; j >= 0; --j) {
                    rawKey = rawKey * (long)DictionaryBasedGroupKeyGenerator.this._cardinalities[j] + (long)DictionaryBasedGroupKeyGenerator.this._singleValueDictIds[j][i];
                }
                outGroupIds[i] = this.getGroupId(rawKey);
            }
        }

        @Override
        public void processMultiValue(int numDocs, int[][] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                long[] rawKeys = DictionaryBasedGroupKeyGenerator.this.getLongRawKeys(i);
                int length = rawKeys.length;
                int[] groupIds = new int[length];
                for (int j = 0; j < length; ++j) {
                    groupIds[j] = this.getGroupId(rawKeys[j]);
                }
                outGroupIds[i] = groupIds;
            }
        }

        private int getGroupId(long rawKey) {
            int numGroups = this._groupIdMap.size();
            if (numGroups < DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound) {
                int id = this._groupIdMap.putIfAbsent(rawKey, numGroups);
                return id == -1 ? numGroups : id;
            }
            return this._groupIdMap.get(rawKey);
        }

        @Override
        public int getGroupIdUpperBound() {
            return this._groupIdMap.size();
        }

        @Override
        public Iterator<GroupKeyGenerator.GroupKey> getGroupKeys() {
            return new Iterator<GroupKeyGenerator.GroupKey>(){
                private final ObjectIterator<Long2IntMap.Entry> _iterator;
                private final GroupKeyGenerator.GroupKey _groupKey;
                {
                    this._iterator = LongMapBasedHolder.this._groupIdMap.long2IntEntrySet().fastIterator();
                    this._groupKey = new GroupKeyGenerator.GroupKey();
                }

                @Override
                public boolean hasNext() {
                    return this._iterator.hasNext();
                }

                @Override
                public GroupKeyGenerator.GroupKey next() {
                    Long2IntMap.Entry entry = (Long2IntMap.Entry)this._iterator.next();
                    this._groupKey._groupId = entry.getIntValue();
                    this._groupKey._keys = DictionaryBasedGroupKeyGenerator.this.getKeys(entry.getLongKey());
                    return this._groupKey;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int getNumKeys() {
            return this._groupIdMap.size();
        }
    }

    private class IntMapBasedHolder
    implements RawKeyHolder {
        private final IntGroupIdMap _groupIdMap;

        public IntMapBasedHolder(IntGroupIdMap groupIdMap) {
            this._groupIdMap = groupIdMap;
        }

        @Override
        public void processSingleValue(int numDocs, int[] outGroupIds) {
            if (DictionaryBasedGroupKeyGenerator.this._numGroupByExpressions == 1) {
                this.processSingleValue(numDocs, DictionaryBasedGroupKeyGenerator.this._singleValueDictIds[0], outGroupIds);
            } else {
                this.processSingleValueGeneric(numDocs, outGroupIds);
            }
        }

        private void processSingleValue(int numDocs, int[] dictIds, int[] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                outGroupIds[i] = this._groupIdMap.getGroupId(dictIds[i], DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound);
            }
        }

        private void processSingleValueGeneric(int numDocs, int[] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                int rawKey = 0;
                for (int j = DictionaryBasedGroupKeyGenerator.this._numGroupByExpressions - 1; j >= 0; --j) {
                    rawKey = rawKey * DictionaryBasedGroupKeyGenerator.this._cardinalities[j] + DictionaryBasedGroupKeyGenerator.this._singleValueDictIds[j][i];
                }
                outGroupIds[i] = this._groupIdMap.getGroupId(rawKey, DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound);
            }
        }

        @Override
        public void processMultiValue(int numDocs, int[][] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                int[] groupIds = DictionaryBasedGroupKeyGenerator.this.getIntRawKeys(i);
                int length = groupIds.length;
                for (int j = 0; j < length; ++j) {
                    groupIds[j] = this._groupIdMap.getGroupId(groupIds[j], DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound);
                }
                outGroupIds[i] = groupIds;
            }
        }

        @Override
        public int getGroupIdUpperBound() {
            return this._groupIdMap.size();
        }

        @Override
        public Iterator<GroupKeyGenerator.GroupKey> getGroupKeys() {
            return new Iterator<GroupKeyGenerator.GroupKey>(){
                private final Iterator<IntGroupIdMap.Entry> _iterator;
                private final GroupKeyGenerator.GroupKey _groupKey;
                {
                    this._iterator = IntMapBasedHolder.this._groupIdMap.iterator();
                    this._groupKey = new GroupKeyGenerator.GroupKey();
                }

                @Override
                public boolean hasNext() {
                    return this._iterator.hasNext();
                }

                @Override
                public GroupKeyGenerator.GroupKey next() {
                    IntGroupIdMap.Entry entry = this._iterator.next();
                    this._groupKey._groupId = entry._groupId;
                    this._groupKey._keys = DictionaryBasedGroupKeyGenerator.this.getKeys(entry._rawKey);
                    return this._groupKey;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int getNumKeys() {
            return this._groupIdMap.size();
        }
    }

    private class ArrayBasedHolder
    implements RawKeyHolder {
        private final boolean[] _flags;
        private int _numKeys;

        private ArrayBasedHolder() {
            this._flags = new boolean[DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound];
            this._numKeys = 0;
        }

        @Override
        public void processSingleValue(int numDocs, int[] outGroupIds) {
            switch (DictionaryBasedGroupKeyGenerator.this._numGroupByExpressions) {
                case 1: {
                    this.processSingleValue(numDocs, DictionaryBasedGroupKeyGenerator.this._singleValueDictIds[0], outGroupIds);
                    return;
                }
                case 2: {
                    this.processSingleValue(numDocs, DictionaryBasedGroupKeyGenerator.this._singleValueDictIds[0], DictionaryBasedGroupKeyGenerator.this._singleValueDictIds[1], outGroupIds);
                    return;
                }
                case 3: {
                    this.processSingleValue(numDocs, DictionaryBasedGroupKeyGenerator.this._singleValueDictIds[0], DictionaryBasedGroupKeyGenerator.this._singleValueDictIds[1], DictionaryBasedGroupKeyGenerator.this._singleValueDictIds[2], outGroupIds);
                    return;
                }
            }
            this.processSingleValueGeneric(numDocs, outGroupIds);
        }

        private void processSingleValue(int numDocs, int[] dictIds, int[] outGroupIds) {
            System.arraycopy(dictIds, 0, outGroupIds, 0, numDocs);
            this.markGroups(numDocs, outGroupIds);
        }

        private void processSingleValue(int numDocs, int[] dictIds0, int[] dictIds1, int[] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                outGroupIds[i] = dictIds1[i] * DictionaryBasedGroupKeyGenerator.this._cardinalities[0] + dictIds0[i];
            }
            this.markGroups(numDocs, outGroupIds);
        }

        private void processSingleValue(int numDocs, int[] dictIds0, int[] dictIds1, int[] dictIds2, int[] outGroupIds) {
            int cardinality = DictionaryBasedGroupKeyGenerator.this._cardinalities[0] * DictionaryBasedGroupKeyGenerator.this._cardinalities[1];
            for (int i = 0; i < numDocs; ++i) {
                outGroupIds[i] = dictIds2[i] * cardinality + dictIds1[i] * DictionaryBasedGroupKeyGenerator.this._cardinalities[0] + dictIds0[i];
            }
            this.markGroups(numDocs, outGroupIds);
        }

        private void markGroups(int numDocs, int[] groupIds) {
            if (this._numKeys < DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound) {
                for (int i = 0; i < numDocs; ++i) {
                    if (this._flags[groupIds[i]]) continue;
                    ++this._numKeys;
                    this._flags[groupIds[i]] = true;
                    if (this._numKeys != DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound) continue;
                    return;
                }
            }
        }

        private void processSingleValueGeneric(int numDocs, int[] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                int groupId = 0;
                for (int j = DictionaryBasedGroupKeyGenerator.this._numGroupByExpressions - 1; j >= 0; --j) {
                    groupId = groupId * DictionaryBasedGroupKeyGenerator.this._cardinalities[j] + DictionaryBasedGroupKeyGenerator.this._singleValueDictIds[j][i];
                }
                outGroupIds[i] = groupId;
                if (this._flags[groupId]) continue;
                ++this._numKeys;
                this._flags[groupId] = true;
            }
        }

        @Override
        public void processMultiValue(int numDocs, int[][] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                int[] groupIds;
                for (int groupId : groupIds = DictionaryBasedGroupKeyGenerator.this.getIntRawKeys(i)) {
                    if (this._flags[groupId]) continue;
                    ++this._numKeys;
                    this._flags[groupId] = true;
                }
                outGroupIds[i] = groupIds;
            }
        }

        @Override
        public int getGroupIdUpperBound() {
            return DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound;
        }

        @Override
        public Iterator<GroupKeyGenerator.GroupKey> getGroupKeys() {
            return new Iterator<GroupKeyGenerator.GroupKey>(){
                private int _currentGroupId;
                private final GroupKeyGenerator.GroupKey _groupKey = new GroupKeyGenerator.GroupKey();
                {
                    while (this._currentGroupId < DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound && !ArrayBasedHolder.this._flags[this._currentGroupId]) {
                        ++this._currentGroupId;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this._currentGroupId < DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound;
                }

                @Override
                public GroupKeyGenerator.GroupKey next() {
                    this._groupKey._groupId = this._currentGroupId;
                    this._groupKey._keys = DictionaryBasedGroupKeyGenerator.this.getKeys(this._currentGroupId);
                    ++this._currentGroupId;
                    while (this._currentGroupId < DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound && !ArrayBasedHolder.this._flags[this._currentGroupId]) {
                        ++this._currentGroupId;
                    }
                    return this._groupKey;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int getNumKeys() {
            return this._numKeys;
        }
    }

    private static interface RawKeyHolder {
        public void processSingleValue(int var1, int[] var2);

        public void processMultiValue(int var1, int[][] var2);

        public int getGroupIdUpperBound();

        public Iterator<GroupKeyGenerator.GroupKey> getGroupKeys();

        public int getNumKeys();
    }
}

