/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;

public class IntGroupByResultHolder
implements GroupByResultHolder {
    private final int _maxCapacity;
    private final int _defaultValue;
    private int _resultHolderCapacity;
    private int[] _resultArray;

    public IntGroupByResultHolder(int initialCapacity, int maxCapacity, int defaultValue) {
        this._maxCapacity = maxCapacity;
        this._defaultValue = defaultValue;
        this._resultHolderCapacity = initialCapacity;
        this._resultArray = new int[initialCapacity];
        if (defaultValue != 0) {
            Arrays.fill(this._resultArray, defaultValue);
        }
    }

    @Override
    public void ensureCapacity(int capacity) {
        Preconditions.checkArgument((capacity <= this._maxCapacity ? 1 : 0) != 0);
        if (capacity > this._resultHolderCapacity) {
            int copyLength = this._resultHolderCapacity;
            this._resultHolderCapacity = Math.max(this._resultHolderCapacity * 2, capacity);
            this._resultHolderCapacity = Math.min(this._resultHolderCapacity, this._maxCapacity);
            int[] current = this._resultArray;
            this._resultArray = new int[this._resultHolderCapacity];
            System.arraycopy(current, 0, this._resultArray, 0, copyLength);
            if (this._defaultValue != 0) {
                Arrays.fill(this._resultArray, copyLength, this._resultHolderCapacity, this._defaultValue);
            }
        }
    }

    @Override
    public double getDoubleResult(int groupKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIntResult(int groupKey) {
        if (groupKey == -1) {
            return this._defaultValue;
        }
        return this._resultArray[groupKey];
    }

    @Override
    public <T> T getResult(int groupKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValueForKey(int groupKey, double newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValueForKey(int groupKey, int newValue) {
        if (groupKey != -1) {
            this._resultArray[groupKey] = newValue;
        }
    }

    @Override
    public void setValueForKey(int groupKey, Object newValue) {
        throw new UnsupportedOperationException();
    }
}

