/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby.utils;

import it.unimi.dsi.fastutil.doubles.Double2IntOpenHashMap;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import org.apache.pinot.core.query.aggregation.groupby.utils.ValueToIdMap;

public class DoubleToIdMap
implements ValueToIdMap {
    private final Double2IntOpenHashMap _valueToIdMap = new Double2IntOpenHashMap();
    private final DoubleArrayList _idToValueMap;

    public DoubleToIdMap() {
        this._valueToIdMap.defaultReturnValue(-1);
        this._idToValueMap = new DoubleArrayList();
    }

    @Override
    public int put(double value) {
        int numValues = this._valueToIdMap.size();
        int id = this._valueToIdMap.computeIfAbsent(value, k -> numValues);
        if (id == numValues) {
            this._idToValueMap.add(value);
        }
        return id;
    }

    @Override
    public int put(Object value) {
        return this.put((Double)value);
    }

    @Override
    public int getId(double value) {
        return this._valueToIdMap.get(value);
    }

    @Override
    public int getId(Object value) {
        return this.getId((Double)value);
    }

    @Override
    public Double get(int id) {
        return this._idToValueMap.getDouble(id);
    }
}

