/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby.utils;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import org.apache.pinot.core.query.aggregation.groupby.utils.ValueToIdMap;

public class LongToIdMap
implements ValueToIdMap {
    private final Long2IntOpenHashMap _valueToIdMap = new Long2IntOpenHashMap();
    private final LongArrayList _idToValueMap;

    public LongToIdMap() {
        this._valueToIdMap.defaultReturnValue(-1);
        this._idToValueMap = new LongArrayList();
    }

    @Override
    public int put(long value) {
        int numValues = this._valueToIdMap.size();
        int id = this._valueToIdMap.computeIfAbsent(value, k -> numValues);
        if (id == numValues) {
            this._idToValueMap.add(value);
        }
        return id;
    }

    @Override
    public int put(Object value) {
        return this.put((Long)value);
    }

    @Override
    public int getId(long value) {
        return this._valueToIdMap.get(value);
    }

    @Override
    public int getId(Object value) {
        return this.getId((Long)value);
    }

    @Override
    public Long get(int id) {
        return this._idToValueMap.getLong(id);
    }
}

