/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby.utils;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import org.apache.pinot.core.query.aggregation.groupby.utils.ValueToIdMap;

public class ObjectToIdMap
implements ValueToIdMap {
    private final Object2IntOpenHashMap<Object> _valueToIdMap = new Object2IntOpenHashMap();
    private final ArrayList<Object> _idToValueMap;

    public ObjectToIdMap() {
        this._valueToIdMap.defaultReturnValue(-1);
        this._idToValueMap = new ArrayList();
    }

    @Override
    public int put(Object value) {
        int numValues = this._valueToIdMap.size();
        int id = this._valueToIdMap.computeIntIfAbsent(value, k -> numValues);
        if (id == numValues) {
            this._idToValueMap.add(value);
        }
        return id;
    }

    @Override
    public int getId(Object value) {
        return this._valueToIdMap.getInt(value);
    }

    @Override
    public Object get(int id) {
        return this._idToValueMap.get(id);
    }
}

