/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.utils.exprminmax;

import java.math.BigDecimal;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.utils.exprminmax.ExprMinMaxWrapperValSet;

public class ExprMinMaxMeasuringValSetWrapper
extends ExprMinMaxWrapperValSet {
    public ExprMinMaxMeasuringValSetWrapper(boolean isSingleValue, DataSchema.ColumnDataType dataType, BlockValSet blockValSet) {
        super(dataType, isSingleValue);
        this.setNewBlock(blockValSet);
    }

    public Comparable getComparable(int i) {
        switch (this._dataType) {
            case INT: 
            case BOOLEAN: {
                return Integer.valueOf(this._intValues[i]);
            }
            case LONG: 
            case TIMESTAMP: {
                return Long.valueOf(this._longValues[i]);
            }
            case FLOAT: {
                return Float.valueOf(this._floatValues[i]);
            }
            case DOUBLE: {
                return Double.valueOf(this._doublesValues[i]);
            }
            case STRING: 
            case BIG_DECIMAL: {
                return (Comparable)this._objectsValues[i];
            }
        }
        throw new IllegalStateException("Unsupported data type: " + this._dataType);
    }

    public int compare(int i, Object o) {
        switch (this._dataType) {
            case INT: 
            case BOOLEAN: {
                return Integer.compare((Integer)o, this._intValues[i]);
            }
            case LONG: 
            case TIMESTAMP: {
                return Long.compare((Long)o, this._longValues[i]);
            }
            case FLOAT: {
                return Float.compare(((Float)o).floatValue(), this._floatValues[i]);
            }
            case DOUBLE: {
                return Double.compare((Double)o, this._doublesValues[i]);
            }
            case STRING: {
                return ((String)o).compareTo((String)this._objectsValues[i]);
            }
            case BIG_DECIMAL: {
                return ((BigDecimal)o).compareTo((BigDecimal)this._objectsValues[i]);
            }
        }
        throw new IllegalStateException("Unsupported data type in comparison" + this._dataType);
    }
}

