/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.query.distinct.DistinctExecutor;
import org.apache.pinot.core.query.distinct.dictionary.DictionaryBasedMultiColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.dictionary.DictionaryBasedMultiColumnDistinctOrderByExecutor;
import org.apache.pinot.core.query.distinct.dictionary.DictionaryBasedSingleColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.dictionary.DictionaryBasedSingleColumnDistinctOrderByExecutor;
import org.apache.pinot.core.query.distinct.raw.RawBigDecimalSingleColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.raw.RawBigDecimalSingleColumnDistinctOrderByExecutor;
import org.apache.pinot.core.query.distinct.raw.RawBytesSingleColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.raw.RawBytesSingleColumnDistinctOrderByExecutor;
import org.apache.pinot.core.query.distinct.raw.RawDoubleSingleColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.raw.RawDoubleSingleColumnDistinctOrderByExecutor;
import org.apache.pinot.core.query.distinct.raw.RawFloatSingleColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.raw.RawFloatSingleColumnDistinctOrderByExecutor;
import org.apache.pinot.core.query.distinct.raw.RawIntSingleColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.raw.RawIntSingleColumnDistinctOrderByExecutor;
import org.apache.pinot.core.query.distinct.raw.RawLongSingleColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.raw.RawLongSingleColumnDistinctOrderByExecutor;
import org.apache.pinot.core.query.distinct.raw.RawMultiColumnDistinctExecutor;
import org.apache.pinot.core.query.distinct.raw.RawStringSingleColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.raw.RawStringSingleColumnDistinctOrderByExecutor;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class DistinctExecutorFactory {
    private DistinctExecutorFactory() {
    }

    public static DistinctExecutor getDistinctExecutor(BaseProjectOperator<?> projectOperator, QueryContext queryContext) {
        List<ExpressionContext> expressions = queryContext.getSelectExpressions();
        List<OrderByExpressionContext> orderByExpressions = queryContext.getOrderByExpressions();
        int limit = queryContext.getLimit();
        if (orderByExpressions == null) {
            return DistinctExecutorFactory.getDistinctOnlyExecutor(expressions, limit, projectOperator, queryContext.isNullHandlingEnabled());
        }
        return DistinctExecutorFactory.getDistinctOrderByExecutor(expressions, orderByExpressions, limit, projectOperator, queryContext.isNullHandlingEnabled());
    }

    private static DistinctExecutor getDistinctOnlyExecutor(List<ExpressionContext> expressions, int limit, BaseProjectOperator<?> projectOperator, boolean nullHandlingEnabled) {
        int numExpressions = expressions.size();
        if (numExpressions == 1) {
            ExpressionContext expression = expressions.get(0);
            ColumnContext columnContext = projectOperator.getResultColumnContext(expression);
            FieldSpec.DataType dataType = columnContext.getDataType();
            Dictionary dictionary = columnContext.getDictionary();
            if (dictionary != null && !nullHandlingEnabled) {
                return new DictionaryBasedSingleColumnDistinctOnlyExecutor(expression, dictionary, dataType, limit);
            }
            switch (dataType.getStoredType()) {
                case INT: {
                    return new RawIntSingleColumnDistinctOnlyExecutor(expression, dataType, limit, nullHandlingEnabled);
                }
                case LONG: {
                    return new RawLongSingleColumnDistinctOnlyExecutor(expression, dataType, limit, nullHandlingEnabled);
                }
                case FLOAT: {
                    return new RawFloatSingleColumnDistinctOnlyExecutor(expression, dataType, limit, nullHandlingEnabled);
                }
                case DOUBLE: {
                    return new RawDoubleSingleColumnDistinctOnlyExecutor(expression, dataType, limit, nullHandlingEnabled);
                }
                case BIG_DECIMAL: {
                    return new RawBigDecimalSingleColumnDistinctOnlyExecutor(expression, dataType, limit, nullHandlingEnabled);
                }
                case STRING: {
                    return new RawStringSingleColumnDistinctOnlyExecutor(expression, dataType, limit, nullHandlingEnabled);
                }
                case BYTES: {
                    return new RawBytesSingleColumnDistinctOnlyExecutor(expression, dataType, limit, nullHandlingEnabled);
                }
            }
            throw new IllegalStateException();
        }
        boolean hasMVExpression = false;
        ArrayList<FieldSpec.DataType> dataTypes = new ArrayList<FieldSpec.DataType>(numExpressions);
        ArrayList<Dictionary> dictionaries = new ArrayList<Dictionary>(numExpressions);
        boolean dictionaryBased = true;
        for (ExpressionContext expression : expressions) {
            ColumnContext columnContext = projectOperator.getResultColumnContext(expression);
            if (!columnContext.isSingleValue()) {
                hasMVExpression = true;
            }
            dataTypes.add(columnContext.getDataType());
            if (!dictionaryBased) continue;
            Dictionary dictionary = columnContext.getDictionary();
            if (dictionary != null) {
                dictionaries.add(dictionary);
                continue;
            }
            dictionaryBased = false;
        }
        if (dictionaryBased) {
            return new DictionaryBasedMultiColumnDistinctOnlyExecutor(expressions, hasMVExpression, dictionaries, dataTypes, limit);
        }
        return new RawMultiColumnDistinctExecutor(expressions, hasMVExpression, dataTypes, null, nullHandlingEnabled, limit);
    }

    private static DistinctExecutor getDistinctOrderByExecutor(List<ExpressionContext> expressions, List<OrderByExpressionContext> orderByExpressions, int limit, BaseProjectOperator<?> projectOperator, boolean nullHandlingEnabled) {
        int numExpressions = expressions.size();
        if (numExpressions == 1) {
            ExpressionContext expression = expressions.get(0);
            ColumnContext columnContext = projectOperator.getResultColumnContext(expression);
            FieldSpec.DataType dataType = columnContext.getDataType();
            assert (orderByExpressions.size() == 1);
            OrderByExpressionContext orderByExpression = orderByExpressions.get(0);
            Dictionary dictionary = columnContext.getDictionary();
            if (dictionary != null && dictionary.isSorted() && !nullHandlingEnabled) {
                return new DictionaryBasedSingleColumnDistinctOrderByExecutor(expression, dictionary, dataType, orderByExpressions.get(0), limit);
            }
            switch (dataType.getStoredType()) {
                case INT: {
                    return new RawIntSingleColumnDistinctOrderByExecutor(expression, dataType, orderByExpression, limit, nullHandlingEnabled);
                }
                case LONG: {
                    return new RawLongSingleColumnDistinctOrderByExecutor(expression, dataType, orderByExpression, limit, nullHandlingEnabled);
                }
                case FLOAT: {
                    return new RawFloatSingleColumnDistinctOrderByExecutor(expression, dataType, orderByExpression, limit, nullHandlingEnabled);
                }
                case DOUBLE: {
                    return new RawDoubleSingleColumnDistinctOrderByExecutor(expression, dataType, orderByExpression, limit, nullHandlingEnabled);
                }
                case BIG_DECIMAL: {
                    return new RawBigDecimalSingleColumnDistinctOrderByExecutor(expression, dataType, orderByExpression, limit, nullHandlingEnabled);
                }
                case STRING: {
                    return new RawStringSingleColumnDistinctOrderByExecutor(expression, dataType, orderByExpression, limit, nullHandlingEnabled);
                }
                case BYTES: {
                    return new RawBytesSingleColumnDistinctOrderByExecutor(expression, dataType, orderByExpression, limit, nullHandlingEnabled);
                }
            }
            throw new IllegalStateException();
        }
        boolean hasMVExpression = false;
        ArrayList<FieldSpec.DataType> dataTypes = new ArrayList<FieldSpec.DataType>(numExpressions);
        ArrayList<Dictionary> dictionaries = new ArrayList<Dictionary>(numExpressions);
        boolean dictionaryBased = true;
        for (ExpressionContext expression : expressions) {
            ColumnContext columnContext = projectOperator.getResultColumnContext(expression);
            if (!columnContext.isSingleValue()) {
                hasMVExpression = true;
            }
            dataTypes.add(columnContext.getDataType());
            if (!dictionaryBased) continue;
            Dictionary dictionary = columnContext.getDictionary();
            if (dictionary != null && dictionary.isSorted()) {
                dictionaries.add(dictionary);
                continue;
            }
            dictionaryBased = false;
        }
        if (dictionaryBased && !nullHandlingEnabled) {
            return new DictionaryBasedMultiColumnDistinctOrderByExecutor(expressions, hasMVExpression, dictionaries, dataTypes, orderByExpressions, limit);
        }
        return new RawMultiColumnDistinctExecutor(expressions, hasMVExpression, dataTypes, orderByExpressions, nullHandlingEnabled, limit);
    }
}

