/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.dictionary;

import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.query.distinct.DistinctExecutorUtils;
import org.apache.pinot.core.query.distinct.dictionary.BaseDictionaryBasedMultiColumnDistinctExecutor;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class DictionaryBasedMultiColumnDistinctOrderByExecutor
extends BaseDictionaryBasedMultiColumnDistinctExecutor {
    private final boolean _hasMVExpression;
    private final PriorityQueue<BaseDictionaryBasedMultiColumnDistinctExecutor.DictIds> _priorityQueue;

    public DictionaryBasedMultiColumnDistinctOrderByExecutor(List<ExpressionContext> expressions, boolean hasMVExpression, List<Dictionary> dictionaries, List<FieldSpec.DataType> dataTypes, List<OrderByExpressionContext> orderByExpressions, int limit) {
        super(expressions, dictionaries, dataTypes, limit);
        this._hasMVExpression = hasMVExpression;
        int numOrderByExpressions = orderByExpressions.size();
        int[] orderByExpressionIndices = new int[numOrderByExpressions];
        int[] comparisonFactors = new int[numOrderByExpressions];
        for (int i = 0; i < numOrderByExpressions; ++i) {
            OrderByExpressionContext orderByExpression = orderByExpressions.get(i);
            orderByExpressionIndices[i] = expressions.indexOf(orderByExpression.getExpression());
            comparisonFactors[i] = orderByExpression.isAsc() ? -1 : 1;
        }
        this._priorityQueue = new ObjectHeapPriorityQueue(Math.min(limit, 10000), (o1, o2) -> {
            int[] dictIds1 = o1._dictIds;
            int[] dictIds2 = o2._dictIds;
            for (int i = 0; i < numOrderByExpressions; ++i) {
                int index = orderByExpressionIndices[i];
                int result = dictIds1[index] - dictIds2[index];
                if (result == 0) continue;
                return result * comparisonFactors[i];
            }
            return 0;
        });
    }

    @Override
    public boolean process(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        int numExpressions = this._expressions.size();
        if (!this._hasMVExpression) {
            int i;
            int[][] dictIdsArray = new int[numDocs][numExpressions];
            for (i = 0; i < numExpressions; ++i) {
                BlockValSet blockValueSet = valueBlock.getBlockValueSet((ExpressionContext)this._expressions.get(i));
                int[] dictIdsForExpression = blockValueSet.getDictionaryIdsSV();
                for (int j = 0; j < numDocs; ++j) {
                    dictIdsArray[j][i] = dictIdsForExpression[j];
                }
            }
            for (i = 0; i < numDocs; ++i) {
                this.add(new BaseDictionaryBasedMultiColumnDistinctExecutor.DictIds(dictIdsArray[i]));
            }
        } else {
            int i;
            int[][] svDictIds = new int[numExpressions][];
            int[][][] mvDictIds = new int[numExpressions][][];
            for (i = 0; i < numExpressions; ++i) {
                BlockValSet blockValueSet = valueBlock.getBlockValueSet((ExpressionContext)this._expressions.get(i));
                if (blockValueSet.isSingleValue()) {
                    svDictIds[i] = blockValueSet.getDictionaryIdsSV();
                    continue;
                }
                mvDictIds[i] = blockValueSet.getDictionaryIdsMV();
            }
            for (i = 0; i < numDocs; ++i) {
                int[][] dictIdsArray;
                for (int[] dictIds : dictIdsArray = DistinctExecutorUtils.getDictIds(svDictIds, mvDictIds, i)) {
                    this.add(new BaseDictionaryBasedMultiColumnDistinctExecutor.DictIds(dictIds));
                }
            }
        }
        return false;
    }

    private void add(BaseDictionaryBasedMultiColumnDistinctExecutor.DictIds dictIds) {
        if (!this._dictIdsSet.contains((Object)dictIds)) {
            if (this._dictIdsSet.size() < this._limit) {
                this._dictIdsSet.add((Object)dictIds);
                this._priorityQueue.enqueue((Object)dictIds);
            } else {
                BaseDictionaryBasedMultiColumnDistinctExecutor.DictIds firstDictIds = (BaseDictionaryBasedMultiColumnDistinctExecutor.DictIds)this._priorityQueue.first();
                if (this._priorityQueue.comparator().compare(dictIds, firstDictIds) > 0) {
                    this._dictIdsSet.remove((Object)firstDictIds);
                    this._dictIdsSet.add((Object)dictIds);
                    this._priorityQueue.dequeue();
                    this._priorityQueue.enqueue((Object)dictIds);
                }
            }
        }
    }
}

