/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.dictionary;

import it.unimi.dsi.fastutil.ints.IntHeapPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntPriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.query.distinct.dictionary.BaseDictionaryBasedSingleColumnDistinctExecutor;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class DictionaryBasedSingleColumnDistinctOrderByExecutor
extends BaseDictionaryBasedSingleColumnDistinctExecutor {
    private final IntPriorityQueue _priorityQueue;

    public DictionaryBasedSingleColumnDistinctOrderByExecutor(ExpressionContext expression, Dictionary dictionary, FieldSpec.DataType dataType, OrderByExpressionContext orderByExpressionContext, int limit) {
        super(expression, dictionary, dataType, limit, false);
        assert (orderByExpressionContext.getExpression().equals((Object)expression));
        int comparisonFactor = orderByExpressionContext.isAsc() ? -1 : 1;
        this._priorityQueue = new IntHeapPriorityQueue(Math.min(limit, 10000), (i1, i2) -> (i1 - i2) * comparisonFactor);
    }

    @Override
    public boolean process(ValueBlock valueBlock) {
        BlockValSet blockValueSet = valueBlock.getBlockValueSet(this._expression);
        int numDocs = valueBlock.getNumDocs();
        if (blockValueSet.isSingleValue()) {
            int[] dictIds = blockValueSet.getDictionaryIdsSV();
            for (int i = 0; i < numDocs; ++i) {
                this.add(dictIds[i]);
            }
        } else {
            int[][] dictIds = blockValueSet.getDictionaryIdsMV();
            for (int i = 0; i < numDocs; ++i) {
                for (int dictId : dictIds[i]) {
                    this.add(dictId);
                }
            }
        }
        return false;
    }

    private void add(int dictId) {
        if (!this._dictIdSet.contains(dictId)) {
            if (this._dictIdSet.size() < this._limit) {
                this._dictIdSet.add(dictId);
                this._priorityQueue.enqueue(dictId);
            } else {
                int firstDictId = this._priorityQueue.firstInt();
                if (this._priorityQueue.comparator().compare(dictId, firstDictId) > 0) {
                    this._dictIdSet.remove(firstDictId);
                    this._dictIdSet.add(dictId);
                    this._priorityQueue.dequeueInt();
                    this._priorityQueue.enqueue(dictId);
                }
            }
        }
    }
}

