/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.query.distinct.DistinctExecutor;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

abstract class BaseRawBytesSingleColumnDistinctExecutor
implements DistinctExecutor {
    final ExpressionContext _expression;
    final FieldSpec.DataType _dataType;
    final int _limit;
    final boolean _nullHandlingEnabled;
    final ObjectSet<ByteArray> _valueSet;
    private boolean _hasNull;

    BaseRawBytesSingleColumnDistinctExecutor(ExpressionContext expression, FieldSpec.DataType dataType, int limit, boolean nullHandlingEnabled) {
        this._expression = expression;
        this._dataType = dataType;
        this._limit = limit;
        this._nullHandlingEnabled = nullHandlingEnabled;
        this._valueSet = new ObjectOpenHashSet(Math.min(limit, 10000));
    }

    @Override
    public DistinctTable getResult() {
        DataSchema dataSchema = new DataSchema(new String[]{this._expression.toString()}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)this._dataType)});
        ArrayList<Record> records = new ArrayList<Record>(this._valueSet.size());
        for (ByteArray value : this._valueSet) {
            records.add(new Record(new Object[]{value}));
        }
        if (this._hasNull) {
            records.add(new Record(new Object[]{null}));
        }
        assert (records.size() - (this._hasNull ? 1 : 0) <= this._limit);
        return new DistinctTable(dataSchema, records, this._nullHandlingEnabled);
    }

    @Override
    public boolean process(ValueBlock valueBlock) {
        BlockValSet blockValueSet = valueBlock.getBlockValueSet(this._expression);
        byte[][] values = blockValueSet.getBytesValuesSV();
        int numDocs = valueBlock.getNumDocs();
        if (this._nullHandlingEnabled) {
            RoaringBitmap nullBitmap = blockValueSet.getNullBitmap();
            for (int i = 0; i < numDocs; ++i) {
                if (nullBitmap != null && nullBitmap.contains(i)) {
                    this._hasNull = true;
                    continue;
                }
                if (!this.add(new ByteArray(values[i]))) continue;
                return true;
            }
        } else {
            for (int i = 0; i < numDocs; ++i) {
                if (!this.add(new ByteArray(values[i]))) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract boolean add(ByteArray var1);
}

