/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.query.distinct.DistinctExecutor;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

abstract class BaseRawIntSingleColumnDistinctExecutor
implements DistinctExecutor {
    final ExpressionContext _expression;
    final FieldSpec.DataType _dataType;
    final int _limit;
    final boolean _nullHandlingEnabled;
    final IntSet _valueSet;
    protected boolean _hasNull;

    BaseRawIntSingleColumnDistinctExecutor(ExpressionContext expression, FieldSpec.DataType dataType, int limit, boolean nullHandlingEnabled) {
        this._expression = expression;
        this._dataType = dataType;
        this._limit = limit;
        this._nullHandlingEnabled = nullHandlingEnabled;
        this._valueSet = new IntOpenHashSet(Math.min(limit, 10000));
    }

    @Override
    public DistinctTable getResult() {
        DataSchema dataSchema = new DataSchema(new String[]{this._expression.toString()}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)this._dataType)});
        ArrayList<Record> records = new ArrayList<Record>(this._valueSet.size() + (this._hasNull ? 1 : 0));
        IntIterator valueIterator = this._valueSet.iterator();
        while (valueIterator.hasNext()) {
            records.add(new Record(new Object[]{valueIterator.nextInt()}));
        }
        if (this._hasNull) {
            records.add(new Record(new Object[]{null}));
        }
        assert (records.size() - (this._hasNull ? 1 : 0) <= this._limit);
        return new DistinctTable(dataSchema, records, this._nullHandlingEnabled);
    }

    @Override
    public boolean process(ValueBlock valueBlock) {
        BlockValSet blockValueSet = valueBlock.getBlockValueSet(this._expression);
        int numDocs = valueBlock.getNumDocs();
        if (blockValueSet.isSingleValue()) {
            int[] values = blockValueSet.getIntValuesSV();
            if (this._nullHandlingEnabled) {
                RoaringBitmap nullBitmap = blockValueSet.getNullBitmap();
                for (int i = 0; i < numDocs; ++i) {
                    if (nullBitmap != null && nullBitmap.contains(i)) {
                        this._hasNull = true;
                        continue;
                    }
                    if (!this.add(values[i])) continue;
                    return true;
                }
            } else {
                for (int i = 0; i < numDocs; ++i) {
                    if (!this.add(values[i])) continue;
                    return true;
                }
            }
        } else {
            int[][] values = blockValueSet.getIntValuesMV();
            for (int i = 0; i < numDocs; ++i) {
                for (int value : values[i]) {
                    if (!this.add(value)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected abstract boolean add(int var1);
}

