/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.math.BigDecimal;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.query.distinct.raw.BaseRawBigDecimalSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;

public class RawBigDecimalSingleColumnDistinctOrderByExecutor
extends BaseRawBigDecimalSingleColumnDistinctExecutor {
    private final PriorityQueue<BigDecimal> _priorityQueue;

    public RawBigDecimalSingleColumnDistinctOrderByExecutor(ExpressionContext expression, FieldSpec.DataType dataType, OrderByExpressionContext orderByExpression, int limit, boolean nullHandlingEnabled) {
        super(expression, dataType, limit, nullHandlingEnabled);
        assert (orderByExpression.getExpression().equals((Object)expression));
        int comparisonFactor = orderByExpression.isAsc() ? -1 : 1;
        this._priorityQueue = new ObjectHeapPriorityQueue(Math.min(limit, 10000), (b1, b2) -> b1.compareTo((BigDecimal)b2) * comparisonFactor);
    }

    @Override
    protected boolean add(BigDecimal value) {
        if (!this._valueSet.contains((Object)value)) {
            if (this._valueSet.size() < this._limit) {
                this._valueSet.add((Object)value);
                this._priorityQueue.enqueue((Object)value);
            } else {
                BigDecimal firstValue = (BigDecimal)this._priorityQueue.first();
                if (this._priorityQueue.comparator().compare(value, firstValue) > 0) {
                    this._valueSet.remove((Object)firstValue);
                    this._valueSet.add((Object)value);
                    this._priorityQueue.dequeue();
                    this._priorityQueue.enqueue((Object)value);
                }
            }
        }
        return false;
    }
}

