/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.query.distinct.raw.BaseRawBytesSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;

public class RawBytesSingleColumnDistinctOrderByExecutor
extends BaseRawBytesSingleColumnDistinctExecutor {
    private final PriorityQueue<ByteArray> _priorityQueue;

    public RawBytesSingleColumnDistinctOrderByExecutor(ExpressionContext expression, FieldSpec.DataType dataType, OrderByExpressionContext orderByExpression, int limit, boolean nullHandlingEnabled) {
        super(expression, dataType, limit, nullHandlingEnabled);
        assert (orderByExpression.getExpression().equals((Object)expression));
        int comparisonFactor = orderByExpression.isAsc() ? -1 : 1;
        this._priorityQueue = new ObjectHeapPriorityQueue(Math.min(limit, 10000), (b1, b2) -> b1.compareTo(b2) * comparisonFactor);
    }

    @Override
    protected boolean add(ByteArray byteArray) {
        if (!this._valueSet.contains((Object)byteArray)) {
            if (this._valueSet.size() < this._limit) {
                this._valueSet.add((Object)byteArray);
                this._priorityQueue.enqueue((Object)byteArray);
            } else {
                ByteArray firstValue = (ByteArray)this._priorityQueue.first();
                if (this._priorityQueue.comparator().compare(byteArray, firstValue) > 0) {
                    this._valueSet.remove((Object)firstValue);
                    this._valueSet.add((Object)byteArray);
                    this._priorityQueue.dequeue();
                    this._priorityQueue.enqueue((Object)byteArray);
                }
            }
        }
        return false;
    }
}

