/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.doubles.DoubleHeapPriorityQueue;
import it.unimi.dsi.fastutil.doubles.DoublePriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.query.distinct.raw.BaseRawDoubleSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;

public class RawDoubleSingleColumnDistinctOrderByExecutor
extends BaseRawDoubleSingleColumnDistinctExecutor {
    private final DoublePriorityQueue _priorityQueue;

    public RawDoubleSingleColumnDistinctOrderByExecutor(ExpressionContext expression, FieldSpec.DataType dataType, OrderByExpressionContext orderByExpression, int limit, boolean nullHandlingEnabled) {
        super(expression, dataType, limit, nullHandlingEnabled);
        assert (orderByExpression.getExpression().equals((Object)expression));
        int comparisonFactor = orderByExpression.isAsc() ? -1 : 1;
        this._priorityQueue = new DoubleHeapPriorityQueue(Math.min(limit, 10000), (d1, d2) -> Double.compare(d1, d2) * comparisonFactor);
    }

    @Override
    protected boolean add(double value) {
        if (!this._valueSet.contains(value)) {
            if (this._valueSet.size() < this._limit) {
                this._valueSet.add(value);
                this._priorityQueue.enqueue(value);
            } else {
                double firstValue = this._priorityQueue.firstDouble();
                if (this._priorityQueue.comparator().compare(value, firstValue) > 0) {
                    this._valueSet.remove(firstValue);
                    this._valueSet.add(value);
                    this._priorityQueue.dequeueDouble();
                    this._priorityQueue.enqueue(value);
                }
            }
        }
        return false;
    }
}

