/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.ints.IntHeapPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntPriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.query.distinct.raw.BaseRawIntSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;

public class RawIntSingleColumnDistinctOrderByExecutor
extends BaseRawIntSingleColumnDistinctExecutor {
    private final IntPriorityQueue _priorityQueue;

    public RawIntSingleColumnDistinctOrderByExecutor(ExpressionContext expression, FieldSpec.DataType dataType, OrderByExpressionContext orderByExpression, int limit, boolean nullHandlingEnabled) {
        super(expression, dataType, limit, nullHandlingEnabled);
        assert (orderByExpression.getExpression().equals((Object)expression));
        int comparisonFactor = orderByExpression.isAsc() ? -1 : 1;
        this._priorityQueue = new IntHeapPriorityQueue(Math.min(limit, 10000), (i1, i2) -> Integer.compare(i1, i2) * comparisonFactor);
    }

    @Override
    protected boolean add(int value) {
        if (!this._valueSet.contains(value)) {
            if (this._valueSet.size() < this._limit) {
                this._valueSet.add(value);
                this._priorityQueue.enqueue(value);
            } else {
                int firstValue = this._priorityQueue.firstInt();
                if (this._priorityQueue.comparator().compare(value, firstValue) > 0) {
                    this._valueSet.remove(firstValue);
                    this._valueSet.add(value);
                    this._priorityQueue.dequeueInt();
                    this._priorityQueue.enqueue(value);
                }
            }
        }
        return false;
    }
}

