/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.longs.LongHeapPriorityQueue;
import it.unimi.dsi.fastutil.longs.LongPriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.query.distinct.raw.BaseRawLongSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;

public class RawLongSingleColumnDistinctOrderByExecutor
extends BaseRawLongSingleColumnDistinctExecutor {
    private final LongPriorityQueue _priorityQueue;

    public RawLongSingleColumnDistinctOrderByExecutor(ExpressionContext expression, FieldSpec.DataType dataType, OrderByExpressionContext orderByExpression, int limit, boolean nullHandlingEnabled) {
        super(expression, dataType, limit, nullHandlingEnabled);
        assert (orderByExpression.getExpression().equals((Object)expression));
        int comparisonFactor = orderByExpression.isAsc() ? -1 : 1;
        this._priorityQueue = new LongHeapPriorityQueue(Math.min(limit, 10000), (l1, l2) -> Long.compare(l1, l2) * comparisonFactor);
    }

    @Override
    protected boolean add(long value) {
        if (!this._valueSet.contains(value)) {
            if (this._valueSet.size() < this._limit) {
                this._valueSet.add(value);
                this._priorityQueue.enqueue(value);
            } else {
                long firstValue = this._priorityQueue.firstLong();
                if (this._priorityQueue.comparator().compare(value, firstValue) > 0) {
                    this._valueSet.remove(firstValue);
                    this._valueSet.add(value);
                    this._priorityQueue.dequeueLong();
                    this._priorityQueue.enqueue(value);
                }
            }
        }
        return false;
    }
}

