/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.RowBasedBlockValueFetcher;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.query.distinct.DistinctExecutor;
import org.apache.pinot.core.query.distinct.DistinctExecutorUtils;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

public class RawMultiColumnDistinctExecutor
implements DistinctExecutor {
    private final List<ExpressionContext> _expressions;
    private final boolean _hasMVExpression;
    private final DistinctTable _distinctTable;
    private final boolean _nullHandlingEnabled;

    public RawMultiColumnDistinctExecutor(List<ExpressionContext> expressions, boolean hasMVExpression, List<FieldSpec.DataType> dataTypes, @Nullable List<OrderByExpressionContext> orderByExpressions, boolean nullHandlingEnabled, int limit) {
        this._expressions = expressions;
        this._hasMVExpression = hasMVExpression;
        this._nullHandlingEnabled = nullHandlingEnabled;
        int numExpressions = expressions.size();
        String[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            columnNames[i] = expressions.get(i).toString();
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)dataTypes.get(i));
        }
        DataSchema dataSchema = new DataSchema(columnNames, columnDataTypes);
        this._distinctTable = new DistinctTable(dataSchema, orderByExpressions, limit, this._nullHandlingEnabled);
    }

    @Override
    public boolean process(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        int numExpressions = this._expressions.size();
        if (!this._hasMVExpression) {
            BlockValSet[] blockValSets = new BlockValSet[numExpressions];
            for (int i = 0; i < numExpressions; ++i) {
                blockValSets[i] = valueBlock.getBlockValueSet(this._expressions.get(i));
            }
            RoaringBitmap[] nullBitmaps = new RoaringBitmap[numExpressions];
            if (this._nullHandlingEnabled) {
                for (int i = 0; i < numExpressions; ++i) {
                    nullBitmaps[i] = blockValSets[i].getNullBitmap();
                }
            }
            RowBasedBlockValueFetcher valueFetcher = new RowBasedBlockValueFetcher(blockValSets);
            for (int docId = 0; docId < numDocs; ++docId) {
                Record record = new Record(valueFetcher.getRow(docId));
                if (this._nullHandlingEnabled) {
                    for (int i = 0; i < numExpressions; ++i) {
                        if (nullBitmaps[i] == null || !nullBitmaps[i].contains(docId)) continue;
                        record.getValues()[i] = null;
                    }
                }
                if (this._distinctTable.hasOrderBy()) {
                    this._distinctTable.addWithOrderBy(record);
                    continue;
                }
                if (!this._distinctTable.addWithoutOrderBy(record)) continue;
                return true;
            }
        } else {
            int i;
            Object[][] svValues = new Object[numExpressions][];
            Object[][][] mvValues = new Object[numExpressions][][];
            for (i = 0; i < numExpressions; ++i) {
                BlockValSet blockValueSet = valueBlock.getBlockValueSet(this._expressions.get(i));
                if (blockValueSet.isSingleValue()) {
                    svValues[i] = this.getSVValues(blockValueSet, numDocs);
                    continue;
                }
                mvValues[i] = this.getMVValues(blockValueSet, numDocs);
            }
            for (i = 0; i < numDocs; ++i) {
                Object[][] records;
                for (Object[] record : records = DistinctExecutorUtils.getRecords(svValues, mvValues, i)) {
                    if (this._distinctTable.hasOrderBy()) {
                        this._distinctTable.addWithOrderBy(new Record(record));
                        continue;
                    }
                    if (!this._distinctTable.addWithoutOrderBy(new Record(record))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Object[] getSVValues(BlockValSet blockValueSet, int numDocs) {
        FieldSpec.DataType storedType = blockValueSet.getValueType().getStoredType();
        switch (storedType) {
            case INT: {
                int[] intValues = blockValueSet.getIntValuesSV();
                Object[] values = new Object[numDocs];
                for (int j = 0; j < numDocs; ++j) {
                    values[j] = intValues[j];
                }
                return values;
            }
            case LONG: {
                long[] longValues = blockValueSet.getLongValuesSV();
                Object[] values = new Object[numDocs];
                for (int j = 0; j < numDocs; ++j) {
                    values[j] = longValues[j];
                }
                return values;
            }
            case FLOAT: {
                float[] floatValues = blockValueSet.getFloatValuesSV();
                Object[] values = new Object[numDocs];
                for (int j = 0; j < numDocs; ++j) {
                    values[j] = Float.valueOf(floatValues[j]);
                }
                return values;
            }
            case DOUBLE: {
                double[] doubleValues = blockValueSet.getDoubleValuesSV();
                Object[] values = new Object[numDocs];
                for (int j = 0; j < numDocs; ++j) {
                    values[j] = doubleValues[j];
                }
                return values;
            }
            case BIG_DECIMAL: {
                return blockValueSet.getBigDecimalValuesSV();
            }
            case STRING: {
                return blockValueSet.getStringValuesSV();
            }
            case BYTES: {
                byte[][] bytesValues = blockValueSet.getBytesValuesSV();
                Object[] values = new Object[numDocs];
                for (int j = 0; j < numDocs; ++j) {
                    values[j] = new ByteArray(bytesValues[j]);
                }
                return values;
            }
        }
        throw new IllegalStateException("Unsupported value type: " + storedType + " for single-value column");
    }

    private Object[][] getMVValues(BlockValSet blockValueSet, int numDocs) {
        FieldSpec.DataType storedType = blockValueSet.getValueType().getStoredType();
        switch (storedType) {
            case INT: {
                int[][] intValues = blockValueSet.getIntValuesMV();
                Object[][] values = new Object[numDocs][];
                for (int j = 0; j < numDocs; ++j) {
                    values[j] = ArrayUtils.toObject((int[])intValues[j]);
                }
                return values;
            }
            case LONG: {
                long[][] longValues = blockValueSet.getLongValuesMV();
                Object[][] values = new Object[numDocs][];
                for (int j = 0; j < numDocs; ++j) {
                    values[j] = ArrayUtils.toObject((long[])longValues[j]);
                }
                return values;
            }
            case FLOAT: {
                float[][] floatValues = blockValueSet.getFloatValuesMV();
                Object[][] values = new Object[numDocs][];
                for (int j = 0; j < numDocs; ++j) {
                    values[j] = ArrayUtils.toObject((float[])floatValues[j]);
                }
                return values;
            }
            case DOUBLE: {
                double[][] doubleValues = blockValueSet.getDoubleValuesMV();
                Object[][] values = new Object[numDocs][];
                for (int j = 0; j < numDocs; ++j) {
                    values[j] = ArrayUtils.toObject((double[])doubleValues[j]);
                }
                return values;
            }
            case STRING: {
                return blockValueSet.getStringValuesMV();
            }
        }
        throw new IllegalStateException("Unsupported value type: " + storedType + " for multi-value column");
    }

    @Override
    public DistinctTable getResult() {
        return this._distinctTable;
    }
}

