/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.query.distinct.raw.BaseRawStringSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;

public class RawStringSingleColumnDistinctOrderByExecutor
extends BaseRawStringSingleColumnDistinctExecutor {
    private final PriorityQueue<String> _priorityQueue;

    public RawStringSingleColumnDistinctOrderByExecutor(ExpressionContext expression, FieldSpec.DataType dataType, OrderByExpressionContext orderByExpression, int limit, boolean nullHandlingEnabled) {
        super(expression, dataType, limit, nullHandlingEnabled);
        assert (orderByExpression.getExpression().equals((Object)expression));
        int comparisonFactor = orderByExpression.isAsc() ? -1 : 1;
        this._priorityQueue = new ObjectHeapPriorityQueue(Math.min(limit, 10000), (s1, s2) -> s1.compareTo((String)s2) * comparisonFactor);
    }

    @Override
    protected boolean add(String value) {
        if (!this._valueSet.contains((Object)value)) {
            if (this._valueSet.size() < this._limit) {
                this._valueSet.add((Object)value);
                this._priorityQueue.enqueue((Object)value);
            } else {
                String firstValue = (String)this._priorityQueue.first();
                if (this._priorityQueue.comparator().compare(value, firstValue) > 0) {
                    this._valueSet.remove((Object)firstValue);
                    this._valueSet.add((Object)value);
                    this._priorityQueue.dequeue();
                    this._priorityQueue.enqueue((Object)value);
                }
            }
        }
        return false;
    }
}

