/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.logger;

import com.google.common.util.concurrent.RateLimiter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.metrics.ServerQueryPhase;
import org.apache.pinot.common.metrics.ServerTimer;
import org.apache.pinot.core.operator.blocks.InstanceResponseBlock;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.request.context.TimerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerQueryLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerQueryLogger.class);
    private static final AtomicReference<ServerQueryLogger> INSTANCE = new AtomicReference();
    private final ServerMetrics _serverMetrics;
    private final RateLimiter _queryLogRateLimiter;
    private final RateLimiter _droppedReportRateLimiter;
    private final AtomicInteger _numDroppedLogs = new AtomicInteger();

    public static void init(double queryLogMaxRate, double droppedReportMaxRate, ServerMetrics serverMetrics) {
        if (INSTANCE.compareAndSet(null, new ServerQueryLogger(queryLogMaxRate, droppedReportMaxRate, serverMetrics))) {
            LOGGER.info("Initialized ServerQueryLogger with query log max rate: {}, dropped report max rate: {}", (Object)queryLogMaxRate, (Object)droppedReportMaxRate);
        } else {
            LOGGER.error("ServerQueryLogger is already initialized, not initializing it again");
        }
    }

    @Nullable
    public static ServerQueryLogger getInstance() {
        return INSTANCE.get();
    }

    private ServerQueryLogger(double queryLogMaxRate, double droppedReportMaxRate, ServerMetrics serverMetrics) {
        this._serverMetrics = serverMetrics;
        this._queryLogRateLimiter = RateLimiter.create((double)queryLogMaxRate);
        this._droppedReportRateLimiter = RateLimiter.create((double)droppedReportMaxRate);
    }

    public void logQuery(ServerQueryRequest request, InstanceResponseBlock response, String schedulerType) {
        long totalCpuTimeNs;
        long responseSerializationCpuTimeNs;
        long systemActivitiesCpuTimeNs;
        String tableNameWithType = request.getTableNameWithType();
        Map<String, String> responseMetadata = response.getResponseMetadata();
        long numDocsScanned = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.NUM_DOCS_SCANNED.getName(), -1L);
        this.addToTableMeter(tableNameWithType, ServerMeter.NUM_DOCS_SCANNED, numDocsScanned);
        long numEntriesScannedInFilter = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.NUM_ENTRIES_SCANNED_IN_FILTER.getName(), -1L);
        this.addToTableMeter(tableNameWithType, ServerMeter.NUM_ENTRIES_SCANNED_IN_FILTER, numEntriesScannedInFilter);
        long numEntriesScannedPostFilter = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.NUM_ENTRIES_SCANNED_POST_FILTER.getName(), -1L);
        this.addToTableMeter(tableNameWithType, ServerMeter.NUM_ENTRIES_SCANNED_POST_FILTER, numEntriesScannedPostFilter);
        long numSegmentsQueried = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.NUM_SEGMENTS_QUERIED.getName(), -1L);
        this.addToTableMeter(tableNameWithType, ServerMeter.NUM_SEGMENTS_QUERIED, numSegmentsQueried);
        long numSegmentsProcessed = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.NUM_SEGMENTS_PROCESSED.getName(), -1L);
        this.addToTableMeter(tableNameWithType, ServerMeter.NUM_SEGMENTS_PROCESSED, numSegmentsProcessed);
        long numSegmentsMatched = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.NUM_SEGMENTS_MATCHED.getName(), -1L);
        this.addToTableMeter(tableNameWithType, ServerMeter.NUM_SEGMENTS_MATCHED, numSegmentsMatched);
        long numSegmentsPrunedInvalid = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.NUM_SEGMENTS_PRUNED_INVALID.getName(), -1L);
        this.addToTableMeter(tableNameWithType, ServerMeter.NUM_SEGMENTS_PRUNED_INVALID, numSegmentsPrunedInvalid);
        long numSegmentsPrunedByLimit = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.NUM_SEGMENTS_PRUNED_BY_LIMIT.getName(), -1L);
        this.addToTableMeter(tableNameWithType, ServerMeter.NUM_SEGMENTS_PRUNED_BY_LIMIT, numSegmentsPrunedByLimit);
        long numSegmentsPrunedByValue = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.NUM_SEGMENTS_PRUNED_BY_VALUE.getName(), -1L);
        this.addToTableMeter(tableNameWithType, ServerMeter.NUM_SEGMENTS_PRUNED_BY_VALUE, numSegmentsPrunedByValue);
        long numConsumingSegmentsQueried = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.NUM_CONSUMING_SEGMENTS_QUERIED.getName(), -1L);
        long numConsumingSegmentsProcessed = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.NUM_CONSUMING_SEGMENTS_PROCESSED.getName(), -1L);
        long numConsumingSegmentsMatched = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.NUM_CONSUMING_SEGMENTS_MATCHED.getName(), -1L);
        long minConsumingFreshnessMs = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.MIN_CONSUMING_FRESHNESS_TIME_MS.getName(), -1L);
        if (minConsumingFreshnessMs > 0L && minConsumingFreshnessMs != Long.MAX_VALUE) {
            this._serverMetrics.addTimedTableValue(tableNameWithType, (AbstractMetrics.Timer)ServerTimer.FRESHNESS_LAG_MS, System.currentTimeMillis() - minConsumingFreshnessMs, TimeUnit.MILLISECONDS);
        }
        long numResizes = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.NUM_RESIZES.getName(), -1L);
        this.addToTableMeter(tableNameWithType, ServerMeter.NUM_RESIZES, numResizes);
        long resizeTimeMs = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.RESIZE_TIME_MS.getName(), -1L);
        this.addToTableMeter(tableNameWithType, ServerMeter.RESIZE_TIME_MS, resizeTimeMs);
        long threadCpuTimeNs = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.THREAD_CPU_TIME_NS.getName(), 0L);
        if (threadCpuTimeNs > 0L) {
            this._serverMetrics.addTimedTableValue(tableNameWithType, (AbstractMetrics.Timer)ServerTimer.EXECUTION_THREAD_CPU_TIME_NS, threadCpuTimeNs, TimeUnit.NANOSECONDS);
            this._serverMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)ServerMeter.TOTAL_THREAD_CPU_TIME_MILLIS, TimeUnit.MILLISECONDS.convert(threadCpuTimeNs, TimeUnit.NANOSECONDS));
        }
        if ((systemActivitiesCpuTimeNs = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.SYSTEM_ACTIVITIES_CPU_TIME_NS.getName(), 0L)) > 0L) {
            this._serverMetrics.addTimedTableValue(tableNameWithType, (AbstractMetrics.Timer)ServerTimer.SYSTEM_ACTIVITIES_CPU_TIME_NS, systemActivitiesCpuTimeNs, TimeUnit.NANOSECONDS);
        }
        if ((responseSerializationCpuTimeNs = ServerQueryLogger.getLongValue(responseMetadata, DataTable.MetadataKey.RESPONSE_SER_CPU_TIME_NS.getName(), 0L)) > 0L) {
            this._serverMetrics.addTimedTableValue(tableNameWithType, (AbstractMetrics.Timer)ServerTimer.RESPONSE_SER_CPU_TIME_NS, responseSerializationCpuTimeNs, TimeUnit.NANOSECONDS);
        }
        if ((totalCpuTimeNs = threadCpuTimeNs + systemActivitiesCpuTimeNs + responseSerializationCpuTimeNs) > 0L) {
            this._serverMetrics.addTimedTableValue(tableNameWithType, (AbstractMetrics.Timer)ServerTimer.TOTAL_CPU_TIME_NS, totalCpuTimeNs, TimeUnit.NANOSECONDS);
        }
        TimerContext timerContext = request.getTimerContext();
        long schedulerWaitMs = timerContext.getPhaseDurationMs(ServerQueryPhase.SCHEDULER_WAIT);
        if (this._queryLogRateLimiter.tryAcquire() || ServerQueryLogger.forceLog(schedulerWaitMs, numDocsScanned, numSegmentsPrunedInvalid)) {
            int numDroppedLogs;
            LOGGER.info("Processed requestId={},table={},segments(queried/processed/matched/consumingQueried/consumingProcessed/consumingMatched/invalid/limit/value)={}/{}/{}/{}/{}/{}/{}/{}/{},schedulerWaitMs={},reqDeserMs={},totalExecMs={},resSerMs={},totalTimeMs={},minConsumingFreshnessMs={},broker={},numDocsScanned={},scanInFilter={},scanPostFilter={},sched={},threadCpuTimeNs(total/thread/sysActivity/resSer)={}/{}/{}/{}", new Object[]{request.getRequestId(), tableNameWithType, numSegmentsQueried, numSegmentsProcessed, numSegmentsMatched, numConsumingSegmentsQueried, numConsumingSegmentsProcessed, numConsumingSegmentsMatched, numSegmentsPrunedInvalid, numSegmentsPrunedByLimit, numSegmentsPrunedByValue, schedulerWaitMs, timerContext.getPhaseDurationMs(ServerQueryPhase.REQUEST_DESERIALIZATION), timerContext.getPhaseDurationMs(ServerQueryPhase.QUERY_PROCESSING), timerContext.getPhaseDurationMs(ServerQueryPhase.RESPONSE_SERIALIZATION), timerContext.getPhaseDurationMs(ServerQueryPhase.TOTAL_QUERY_TIME), minConsumingFreshnessMs, request.getBrokerId(), numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, schedulerType, totalCpuTimeNs, threadCpuTimeNs, systemActivitiesCpuTimeNs, responseSerializationCpuTimeNs});
            if (this._droppedReportRateLimiter.tryAcquire() && (numDroppedLogs = this._numDroppedLogs.get()) > 0) {
                LOGGER.info("{} logs were dropped. (log max rate per second: {})", (Object)numDroppedLogs, (Object)this._queryLogRateLimiter.getRate());
                this._numDroppedLogs.set(0);
            }
        } else {
            this._numDroppedLogs.getAndIncrement();
        }
    }

    private static long getLongValue(Map<String, String> metadata, String key, long defaultValue) {
        String value = metadata.get(key);
        return value != null ? Long.parseLong(value) : defaultValue;
    }

    private void addToTableMeter(String tableNameWithType, ServerMeter meter, long value) {
        if (value > 0L) {
            this._serverMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)meter, value);
        }
    }

    private static boolean forceLog(long schedulerWaitMs, long numDocsScanned, long numSegmentsPrunedInvalid) {
        if (schedulerWaitMs > 100L) {
            return true;
        }
        if (numDocsScanned > 1000000L) {
            return true;
        }
        return numSegmentsPrunedInvalid > 0L;
    }
}

