/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.core.query.optimizer.filter.FilterOptimizer;
import org.apache.pinot.core.query.optimizer.filter.FlattenAndOrFilterOptimizer;
import org.apache.pinot.core.query.optimizer.filter.IdenticalPredicateFilterOptimizer;
import org.apache.pinot.core.query.optimizer.filter.MergeEqInFilterOptimizer;
import org.apache.pinot.core.query.optimizer.filter.MergeRangeFilterOptimizer;
import org.apache.pinot.core.query.optimizer.filter.NumericalFilterOptimizer;
import org.apache.pinot.core.query.optimizer.filter.TextMatchFilterOptimizer;
import org.apache.pinot.core.query.optimizer.filter.TimePredicateFilterOptimizer;
import org.apache.pinot.core.query.optimizer.statement.StatementOptimizer;
import org.apache.pinot.core.query.optimizer.statement.StringPredicateFilterOptimizer;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

public class QueryOptimizer {
    private static final List<FilterOptimizer> FILTER_OPTIMIZERS = Arrays.asList(new FlattenAndOrFilterOptimizer(), new IdenticalPredicateFilterOptimizer(), new MergeEqInFilterOptimizer(), new NumericalFilterOptimizer(), new TimePredicateFilterOptimizer(), new MergeRangeFilterOptimizer(), new TextMatchFilterOptimizer());
    private static final List<StatementOptimizer> STATEMENT_OPTIMIZERS = Collections.singletonList(new StringPredicateFilterOptimizer());

    public void optimize(PinotQuery pinotQuery, @Nullable Schema schema) {
        this.optimize(pinotQuery, null, schema);
    }

    public void optimize(PinotQuery pinotQuery, @Nullable TableConfig tableConfig, @Nullable Schema schema) {
        Expression filterExpression = pinotQuery.getFilterExpression();
        if (filterExpression != null) {
            for (FilterOptimizer filterOptimizer : FILTER_OPTIMIZERS) {
                filterExpression = filterOptimizer.optimize(filterExpression, schema);
            }
            pinotQuery.setFilterExpression(filterExpression);
        }
        for (StatementOptimizer statementOptimizer : STATEMENT_OPTIMIZERS) {
            statementOptimizer.optimize(pinotQuery, tableConfig, schema);
        }
    }
}

