/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.filter;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.core.query.optimizer.filter.FilterOptimizer;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.sql.FilterKind;

public abstract class BaseAndOrBooleanFilterOptimizer
implements FilterOptimizer {
    protected static final Expression TRUE = RequestUtils.getLiteralExpression((boolean)true);
    protected static final Expression FALSE = RequestUtils.getLiteralExpression((boolean)false);

    @Override
    public Expression optimize(Expression filterExpression, @Nullable Schema schema) {
        if (!this.canBeOptimized(filterExpression, schema)) {
            return filterExpression;
        }
        Function function = filterExpression.getFunctionCall();
        List operands = function.getOperands();
        FilterKind kind = FilterKind.valueOf((String)function.getOperator());
        switch (kind) {
            case AND: 
            case OR: 
            case NOT: {
                operands.replaceAll(operand -> this.optimize((Expression)operand, schema));
                return this.optimizeCurrent(filterExpression);
            }
        }
        return this.optimizeChild(filterExpression, schema);
    }

    abstract boolean canBeOptimized(Expression var1, @Nullable Schema var2);

    abstract Expression optimizeChild(Expression var1, @Nullable Schema var2);

    protected Expression optimizeCurrent(Expression expression) {
        Function function = expression.getFunctionCall();
        String operator = function.getOperator();
        List operands = function.getOperands();
        if (operator.equals(FilterKind.AND.name())) {
            for (Expression operand2 : operands) {
                if (!operand2.equals(FALSE)) continue;
                return FALSE;
            }
            operands.removeIf(operand -> operand.equals(TRUE));
            if (operands.isEmpty()) {
                return TRUE;
            }
        } else if (operator.equals(FilterKind.OR.name())) {
            for (Expression operand3 : operands) {
                if (!operand3.equals(TRUE)) continue;
                return TRUE;
            }
            operands.removeIf(operand -> operand.equals(FALSE));
            if (operands.isEmpty()) {
                return FALSE;
            }
        } else if (operator.equals(FilterKind.NOT.name())) {
            assert (operands.size() == 1);
            Expression operand4 = (Expression)operands.get(0);
            if (operand4.equals(TRUE)) {
                return FALSE;
            }
            if (operand4.equals(FALSE)) {
                return TRUE;
            }
        }
        return expression;
    }

    protected static Expression getExpressionFromBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }
}

