/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.core.query.optimizer.filter.FilterOptimizer;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.sql.FilterKind;

public class MergeEqInFilterOptimizer
implements FilterOptimizer {
    @Override
    public Expression optimize(Expression filterExpression, @Nullable Schema schema) {
        return filterExpression.getType() == ExpressionType.FUNCTION ? this.optimize(filterExpression) : filterExpression;
    }

    private Expression optimize(Expression filterExpression) {
        Function function = filterExpression.getFunctionCall();
        if (function == null) {
            return filterExpression;
        }
        String operator = function.getOperator();
        if (operator.equals(FilterKind.OR.name())) {
            List children = function.getOperands();
            HashMap valuesMap = new HashMap();
            ArrayList<Expression> newChildren = new ArrayList<Expression>();
            boolean recreateFilter = false;
            for (Expression child : children) {
                Expression lhs;
                List operands;
                Function childFunction = child.getFunctionCall();
                if (childFunction == null) {
                    newChildren.add(child);
                    continue;
                }
                String childOperator = childFunction.getOperator();
                assert (!childOperator.equals(FilterKind.OR.name()));
                if (childOperator.equals(FilterKind.AND.name()) || childOperator.equals(FilterKind.NOT.name())) {
                    childFunction.getOperands().replaceAll(this::optimize);
                    newChildren.add(child);
                    continue;
                }
                if (childOperator.equals(FilterKind.EQUALS.name())) {
                    operands = childFunction.getOperands();
                    lhs = (Expression)operands.get(0);
                    Expression value = (Expression)operands.get(1);
                    HashSet<Expression> values = (HashSet<Expression>)valuesMap.get(lhs);
                    if (values == null) {
                        values = new HashSet<Expression>();
                        values.add(value);
                        valuesMap.put(lhs, values);
                        continue;
                    }
                    values.add(value);
                    recreateFilter = true;
                    continue;
                }
                if (childOperator.equals(FilterKind.IN.name())) {
                    Set values;
                    operands = childFunction.getOperands();
                    lhs = (Expression)operands.get(0);
                    HashSet<Expression> inPredicateValuesSet = new HashSet<Expression>();
                    int numOperands = operands.size();
                    for (int i = 1; i < numOperands; ++i) {
                        inPredicateValuesSet.add((Expression)operands.get(i));
                    }
                    int numUniqueValues = inPredicateValuesSet.size();
                    if (numUniqueValues == 1 || numUniqueValues != numOperands - 1) {
                        recreateFilter = true;
                    }
                    if ((values = (Set)valuesMap.get(lhs)) == null) {
                        valuesMap.put(lhs, inPredicateValuesSet);
                        continue;
                    }
                    values.addAll(inPredicateValuesSet);
                    recreateFilter = true;
                    continue;
                }
                newChildren.add(child);
            }
            if (recreateFilter) {
                if (newChildren.isEmpty() && valuesMap.size() == 1) {
                    Map.Entry entry = valuesMap.entrySet().iterator().next();
                    return MergeEqInFilterOptimizer.getFilterExpression((Expression)entry.getKey(), (Set)entry.getValue());
                }
                for (Map.Entry entry : valuesMap.entrySet()) {
                    newChildren.add(MergeEqInFilterOptimizer.getFilterExpression((Expression)entry.getKey(), (Set)entry.getValue()));
                }
                function.setOperands(newChildren);
                return filterExpression;
            }
            return filterExpression;
        }
        if (operator.equals(FilterKind.AND.name())) {
            function.getOperands().replaceAll(this::optimize);
            return filterExpression;
        }
        if (operator.equals(FilterKind.IN.name())) {
            List operands = function.getOperands();
            Expression lhs = (Expression)operands.get(0);
            HashSet<Expression> values = new HashSet<Expression>();
            int numOperands = operands.size();
            for (int i = 1; i < numOperands; ++i) {
                values.add((Expression)operands.get(i));
            }
            int numUniqueValues = values.size();
            if (numUniqueValues == 1 || numUniqueValues != numOperands - 1) {
                return MergeEqInFilterOptimizer.getFilterExpression(lhs, values);
            }
            return filterExpression;
        }
        return filterExpression;
    }

    private static Expression getFilterExpression(Expression lhs, Set<Expression> values) {
        int numValues = values.size();
        if (numValues == 1) {
            return RequestUtils.getFunctionExpression((String)FilterKind.EQUALS.name(), (Expression[])new Expression[]{lhs, values.iterator().next()});
        }
        ArrayList<Expression> operands = new ArrayList<Expression>(numValues + 1);
        operands.add(lhs);
        operands.addAll(values);
        return RequestUtils.getFunctionExpression((String)FilterKind.IN.name(), operands);
    }
}

