/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.core.query.optimizer.filter.FilterOptimizer;
import org.apache.pinot.core.query.optimizer.filter.Range;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.sql.FilterKind;

public class MergeRangeFilterOptimizer
implements FilterOptimizer {
    @Override
    public Expression optimize(Expression filterExpression, @Nullable Schema schema) {
        if (schema == null || filterExpression.getType() != ExpressionType.FUNCTION) {
            return filterExpression;
        }
        Function function = filterExpression.getFunctionCall();
        String operator = function.getOperator();
        if (operator.equals(FilterKind.AND.name())) {
            List children = function.getOperands();
            HashMap<String, Range> rangeMap = new HashMap<String, Range>();
            ArrayList<Expression> newChildren = new ArrayList<Expression>();
            boolean recreateFilter = false;
            for (Expression expression : children) {
                Function childFunction = expression.getFunctionCall();
                FilterKind filterKind = FilterKind.valueOf((String)childFunction.getOperator());
                assert (filterKind != FilterKind.AND);
                if (filterKind == FilterKind.OR || filterKind == FilterKind.NOT) {
                    childFunction.getOperands().replaceAll(o -> this.optimize((Expression)o, schema));
                    newChildren.add(expression);
                    continue;
                }
                if (filterKind.isRange()) {
                    List operands = childFunction.getOperands();
                    Expression lhs = (Expression)operands.get(0);
                    if (lhs.getType() != ExpressionType.IDENTIFIER) {
                        newChildren.add(expression);
                        continue;
                    }
                    String column = lhs.getIdentifier().getName();
                    FieldSpec fieldSpec = schema.getFieldSpecFor(column);
                    if (fieldSpec == null || !fieldSpec.isSingleValueField()) {
                        newChildren.add(expression);
                        continue;
                    }
                    FieldSpec.DataType dataType = fieldSpec.getDataType();
                    Range range = MergeRangeFilterOptimizer.getRange(filterKind, operands, dataType);
                    Range currentRange = (Range)rangeMap.get(column);
                    if (currentRange == null) {
                        rangeMap.put(column, range);
                        continue;
                    }
                    currentRange.intersect(range);
                    recreateFilter = true;
                    continue;
                }
                newChildren.add(expression);
            }
            if (recreateFilter) {
                if (newChildren.isEmpty() && rangeMap.size() == 1) {
                    Map.Entry entry = rangeMap.entrySet().iterator().next();
                    return MergeRangeFilterOptimizer.getRangeFilterExpression((String)entry.getKey(), (Range)entry.getValue());
                }
                for (Map.Entry entry : rangeMap.entrySet()) {
                    newChildren.add(MergeRangeFilterOptimizer.getRangeFilterExpression((String)entry.getKey(), (Range)entry.getValue()));
                }
                function.setOperands(newChildren);
                return filterExpression;
            }
            return filterExpression;
        }
        if (operator.equals(FilterKind.OR.name()) || operator.equals(FilterKind.NOT.name())) {
            function.getOperands().replaceAll(c -> this.optimize((Expression)c, schema));
            return filterExpression;
        }
        return filterExpression;
    }

    private static Range getRange(FilterKind filterKind, List<Expression> operands, FieldSpec.DataType dataType) {
        switch (filterKind) {
            case GREATER_THAN: {
                return new Range(MergeRangeFilterOptimizer.getComparable(operands.get(1), dataType), false, null, false);
            }
            case GREATER_THAN_OR_EQUAL: {
                return new Range(MergeRangeFilterOptimizer.getComparable(operands.get(1), dataType), true, null, false);
            }
            case LESS_THAN: {
                return new Range(null, false, MergeRangeFilterOptimizer.getComparable(operands.get(1), dataType), false);
            }
            case LESS_THAN_OR_EQUAL: {
                return new Range(null, false, MergeRangeFilterOptimizer.getComparable(operands.get(1), dataType), true);
            }
            case BETWEEN: {
                return new Range(MergeRangeFilterOptimizer.getComparable(operands.get(1), dataType), true, MergeRangeFilterOptimizer.getComparable(operands.get(2), dataType), true);
            }
            case RANGE: {
                return Range.getRange(operands.get(1).getLiteral().getStringValue(), dataType);
            }
        }
        throw new IllegalStateException("Unsupported filter kind: " + filterKind);
    }

    private static Comparable getComparable(Expression literalExpression, FieldSpec.DataType dataType) {
        return dataType.convertInternal(RequestUtils.getLiteralString((Expression)literalExpression));
    }

    private static Expression getRangeFilterExpression(String column, Range range) {
        return RequestUtils.getFunctionExpression((String)FilterKind.RANGE.name(), (Expression[])new Expression[]{RequestUtils.getIdentifierExpression((String)column), RequestUtils.getLiteralExpression((String)range.getRangeString())});
    }
}

