/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.filter;

import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.core.query.optimizer.filter.BaseAndOrBooleanFilterOptimizer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.sql.FilterKind;

public class NumericalFilterOptimizer
extends BaseAndOrBooleanFilterOptimizer {
    @Override
    boolean canBeOptimized(Expression filterExpression, @Nullable Schema schema) {
        ExpressionType type = filterExpression.getType();
        return type == ExpressionType.FUNCTION && schema != null;
    }

    @Override
    Expression optimizeChild(Expression filterExpression, @Nullable Schema schema) {
        Function function = filterExpression.getFunctionCall();
        FilterKind kind = FilterKind.valueOf((String)function.getOperator());
        switch (kind) {
            case IS_NULL: 
            case IS_NOT_NULL: {
                break;
            }
            default: {
                FieldSpec.DataType dataType;
                List operands = function.getOperands();
                Expression lhs = (Expression)operands.get(0);
                Expression rhs = (Expression)operands.get(1);
                if (!NumericalFilterOptimizer.isNumericLiteral(rhs) || (dataType = NumericalFilterOptimizer.getDataType(lhs, schema)) == null || !dataType.isNumeric()) break;
                switch (kind) {
                    case EQUALS: 
                    case NOT_EQUALS: {
                        return NumericalFilterOptimizer.rewriteEqualsExpression(filterExpression, kind, dataType, rhs);
                    }
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: 
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: {
                        return NumericalFilterOptimizer.rewriteRangeExpression(filterExpression, kind, dataType, rhs);
                    }
                }
            }
        }
        return filterExpression;
    }

    private static Expression rewriteEqualsExpression(Expression equals, FilterKind kind, FieldSpec.DataType dataType, Expression rhs) {
        boolean result = kind == FilterKind.NOT_EQUALS;
        block0 : switch ((Literal._Fields)rhs.getLiteral().getSetField()) {
            case INT_VALUE: {
                break;
            }
            case LONG_VALUE: {
                long actual = rhs.getLiteral().getLongValue();
                switch (dataType) {
                    case INT: {
                        int converted = (int)actual;
                        if ((long)converted != actual) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(result);
                        }
                        rhs.getLiteral().setLongValue((long)converted);
                        break block0;
                    }
                    case FLOAT: {
                        float converted = actual;
                        if (BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted)) != 0) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(result);
                        }
                        rhs.getLiteral().setDoubleValue((double)converted);
                        break block0;
                    }
                    case DOUBLE: {
                        double converted = actual;
                        if (BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted)) != 0) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(result);
                        }
                        rhs.getLiteral().setDoubleValue(converted);
                        break block0;
                    }
                }
                break;
            }
            case FLOAT_VALUE: {
                float actual = Float.intBitsToFloat(rhs.getLiteral().getFloatValue());
                System.out.println(actual);
                break;
            }
            case DOUBLE_VALUE: {
                double actual = rhs.getLiteral().getDoubleValue();
                switch (dataType) {
                    case INT: {
                        int converted = (int)actual;
                        if ((double)converted != actual) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(result);
                        }
                        rhs.getLiteral().setLongValue((long)converted);
                        break block0;
                    }
                    case LONG: {
                        long converted = (long)actual;
                        if (BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted)) != 0) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(result);
                        }
                        rhs.getLiteral().setLongValue(converted);
                        break block0;
                    }
                }
                break;
            }
        }
        return equals;
    }

    private static Expression rewriteRangeExpression(Expression range, FilterKind kind, FieldSpec.DataType dataType, Expression rhs) {
        block0 : switch ((Literal._Fields)rhs.getLiteral().getSetField()) {
            case INT_VALUE: {
                break;
            }
            case LONG_VALUE: {
                long actual = rhs.getLiteral().getLongValue();
                switch (dataType) {
                    case INT: {
                        int converted = (int)actual;
                        int comparison = Long.compare(actual, converted);
                        if (comparison > 0) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL);
                        }
                        if (comparison >= 0) break block0;
                        return NumericalFilterOptimizer.getExpressionFromBoolean(kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL);
                    }
                    case FLOAT: {
                        float converted = actual;
                        int comparison = BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted));
                        NumericalFilterOptimizer.rewriteRangeOperator(range, kind, comparison);
                        rhs.getLiteral().setDoubleValue((double)converted);
                        break block0;
                    }
                    case DOUBLE: {
                        double converted = actual;
                        int comparison = BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted));
                        NumericalFilterOptimizer.rewriteRangeOperator(range, kind, comparison);
                        rhs.getLiteral().setDoubleValue(converted);
                        break block0;
                    }
                }
                break;
            }
            case FLOAT_VALUE: {
                float actual = Float.intBitsToFloat(rhs.getLiteral().getFloatValue());
                System.out.println(actual);
                break;
            }
            case DOUBLE_VALUE: {
                double actual = rhs.getLiteral().getDoubleValue();
                switch (dataType) {
                    case INT: {
                        int converted = (int)actual;
                        int comparison = Double.compare(actual, converted);
                        if (comparison > 0 && converted == Integer.MAX_VALUE) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL);
                        }
                        if (comparison < 0 && converted == Integer.MIN_VALUE) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL);
                        }
                        NumericalFilterOptimizer.rewriteRangeOperator(range, kind, comparison);
                        rhs.getLiteral().setLongValue((long)converted);
                        break block0;
                    }
                    case LONG: {
                        long converted = (long)actual;
                        int comparison = BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted));
                        if (comparison > 0 && converted == Long.MAX_VALUE) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL);
                        }
                        if (comparison < 0 && converted == Long.MIN_VALUE) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL);
                        }
                        NumericalFilterOptimizer.rewriteRangeOperator(range, kind, comparison);
                        rhs.getLiteral().setLongValue(converted);
                        break block0;
                    }
                    case FLOAT: {
                        float converted = (float)actual;
                        if (converted == Float.POSITIVE_INFINITY) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL);
                        }
                        if (converted != Float.NEGATIVE_INFINITY) break block0;
                        return NumericalFilterOptimizer.getExpressionFromBoolean(kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL);
                    }
                }
                break;
            }
        }
        return range;
    }

    private static void rewriteRangeOperator(Expression range, FilterKind kind, int comparison) {
        if (comparison > 0) {
            if (kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL) {
                range.getFunctionCall().setOperator(FilterKind.GREATER_THAN.name());
            } else if (kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL) {
                range.getFunctionCall().setOperator(FilterKind.LESS_THAN_OR_EQUAL.name());
            }
        } else if (comparison < 0) {
            if (kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL) {
                range.getFunctionCall().setOperator(FilterKind.GREATER_THAN_OR_EQUAL.name());
            } else if (kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL) {
                range.getFunctionCall().setOperator(FilterKind.LESS_THAN.name());
            }
        }
    }

    @Nullable
    private static FieldSpec.DataType getDataType(Expression expression, Schema schema) {
        if (expression.getType() == ExpressionType.IDENTIFIER) {
            String column = expression.getIdentifier().getName();
            FieldSpec fieldSpec = schema.getFieldSpecFor(column);
            if (fieldSpec != null && fieldSpec.isSingleValueField()) {
                return fieldSpec.getDataType();
            }
        } else if (expression.getType() == ExpressionType.FUNCTION && "cast".equalsIgnoreCase(expression.getFunctionCall().getOperator())) {
            String targetTypeLiteral = ((Expression)expression.getFunctionCall().getOperands().get(1)).getLiteral().getStringValue().toUpperCase();
            if (targetTypeLiteral.endsWith("_ARRAY")) {
                targetTypeLiteral = targetTypeLiteral.substring(0, targetTypeLiteral.length() - 6);
            }
            FieldSpec.DataType dataType = "INTEGER".equals(targetTypeLiteral) ? FieldSpec.DataType.INT : ("VARCHAR".equals(targetTypeLiteral) ? FieldSpec.DataType.STRING : FieldSpec.DataType.valueOf((String)targetTypeLiteral));
            return dataType;
        }
        return null;
    }

    private static boolean isNumericLiteral(Expression expression) {
        if (expression.getType() == ExpressionType.LITERAL) {
            Literal._Fields type = (Literal._Fields)expression.getLiteral().getSetField();
            switch (type) {
                case INT_VALUE: 
                case LONG_VALUE: 
                case FLOAT_VALUE: 
                case DOUBLE_VALUE: {
                    return true;
                }
            }
        }
        return false;
    }
}

