/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.core.query.optimizer.filter.FilterOptimizer;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.sql.FilterKind;

public class TextMatchFilterOptimizer
implements FilterOptimizer {
    private static final String SPACE = " ";

    @Override
    public Expression optimize(Expression filterExpression, @Nullable Schema schema) {
        return filterExpression.getType() == ExpressionType.FUNCTION ? this.optimize(filterExpression) : filterExpression;
    }

    private Expression optimize(Expression filterExpression) {
        Function function = filterExpression.getFunctionCall();
        if (function == null) {
            return filterExpression;
        }
        String operator = function.getOperator();
        if (!(operator.equals(FilterKind.OR.name()) || operator.equals(FilterKind.AND.name()) || operator.equals(FilterKind.NOT.name()))) {
            return filterExpression;
        }
        List children = function.getOperands();
        children.replaceAll(this::optimize);
        ArrayList<Expression> newChildren = new ArrayList<Expression>();
        HashMap<Expression, List<Expression>> textMatchMap = new HashMap<Expression, List<Expression>>();
        boolean recreateFilter = false;
        for (Expression child : children) {
            Function childFunction = child.getFunctionCall();
            if (childFunction == null) {
                newChildren.add(child);
                continue;
            }
            String childOperator = childFunction.getOperator();
            if (childOperator.equals(FilterKind.TEXT_MATCH.name())) {
                List operands = childFunction.getOperands();
                Expression identifier = (Expression)operands.get(0);
                textMatchMap.computeIfAbsent(identifier, k -> new ArrayList()).add(child);
                continue;
            }
            if (childOperator.equals(FilterKind.NOT.name())) {
                assert (childFunction.getOperands().size() == 1);
                Expression operand = (Expression)childFunction.getOperands().get(0);
                Function notChildFunction = operand.getFunctionCall();
                if (notChildFunction == null) {
                    newChildren.add(child);
                    continue;
                }
                if (notChildFunction.getOperator().equals(FilterKind.TEXT_MATCH.name())) {
                    List operands = notChildFunction.getOperands();
                    Expression identifier = (Expression)operands.get(0);
                    textMatchMap.computeIfAbsent(identifier, k -> new ArrayList()).add(child);
                    continue;
                }
                newChildren.add(child);
                continue;
            }
            Expression newChild = this.optimize(child);
            if (!newChild.equals(child)) {
                recreateFilter = true;
            }
            newChildren.add(this.optimize(child));
        }
        for (List values : textMatchMap.values()) {
            if (values.size() <= 1) continue;
            recreateFilter = true;
            break;
        }
        if (recreateFilter) {
            return this.getNewFilter(operator, newChildren, textMatchMap);
        }
        return filterExpression;
    }

    /*
     * WARNING - void declaration
     */
    private Expression getNewFilter(String operator, List<Expression> newChildren, Map<Expression, List<Expression>> textMatchMap) {
        for (Map.Entry<Expression, List<Expression>> entry : textMatchMap.entrySet()) {
            void var8_8;
            Expression operand;
            boolean allNot = true;
            for (Expression expression : entry.getValue()) {
                if (expression.getFunctionCall().getOperator().equals(FilterKind.NOT.name())) continue;
                allNot = false;
                break;
            }
            ArrayList<Object> literals = new ArrayList<Object>();
            if (allNot) {
                for (Expression expression : entry.getValue()) {
                    operand = (Expression)expression.getFunctionCall().getOperands().get(0);
                    literals.add(((Expression)operand.getFunctionCall().getOperands().get(1)).getLiteral().getStringValue());
                }
            } else {
                for (Expression expression : entry.getValue()) {
                    if (expression.getFunctionCall().getOperator().equals(FilterKind.NOT.name())) {
                        operand = (Expression)expression.getFunctionCall().getOperands().get(0);
                        literals.add(FilterKind.NOT.name() + SPACE + ((Expression)operand.getFunctionCall().getOperands().get(1)).getLiteral().getStringValue());
                        continue;
                    }
                    assert (expression.getFunctionCall().getOperator().equals(FilterKind.TEXT_MATCH.name()));
                    literals.add(((Expression)expression.getFunctionCall().getOperands().get(1)).getLiteral().getStringValue());
                }
            }
            if (allNot) {
                assert (operator.equals(FilterKind.AND.name()) || operator.equals(FilterKind.OR.name()));
                if (operator.equals(FilterKind.AND.name())) {
                    String string = String.join((CharSequence)(SPACE + FilterKind.OR.name() + SPACE), literals);
                } else {
                    String string = String.join((CharSequence)(SPACE + FilterKind.AND.name() + SPACE), literals);
                }
            } else {
                String string = String.join((CharSequence)(SPACE + operator + SPACE), literals);
            }
            Expression mergedTextMatchExpression = RequestUtils.getFunctionExpression((String)FilterKind.TEXT_MATCH.name(), (Expression[])new Expression[]{entry.getKey(), RequestUtils.getLiteralExpression((String)("(" + (String)var8_8 + ")"))});
            if (allNot) {
                newChildren.add(RequestUtils.getFunctionExpression((String)FilterKind.NOT.name(), (Expression)mergedTextMatchExpression));
                continue;
            }
            newChildren.add(mergedTextMatchExpression);
        }
        if (newChildren.size() == 1) {
            return newChildren.get(0);
        }
        assert (operator.equals(FilterKind.OR.name()) || operator.equals(FilterKind.AND.name()));
        return RequestUtils.getFunctionExpression((String)operator, newChildren);
    }
}

