/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.prefetch;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pinot.core.query.prefetch.DefaultFetchPlanner;
import org.apache.pinot.core.query.prefetch.FetchPlanner;

public class FetchPlannerRegistry {
    private static final AtomicReference<FetchPlanner> REGISTRATION = new AtomicReference<Object>(null);

    private FetchPlannerRegistry() {
    }

    public static boolean registerPlanner(FetchPlanner planner) {
        return REGISTRATION.compareAndSet(null, planner);
    }

    public static FetchPlanner getPlanner() {
        return Holder.PLANNER;
    }

    private static final class Holder {
        public static final FetchPlanner PLANNER = Optional.ofNullable(REGISTRATION.get()).orElseGet(DefaultFetchPlanner::new);

        private Holder() {
        }
    }
}

