/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.pruner;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RangePredicate;
import org.apache.pinot.core.query.pruner.ValueBasedSegmentPruner;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.data.FieldSpec;

public class ColumnValueSegmentPruner
extends ValueBasedSegmentPruner {
    @Override
    protected boolean isApplicableToPredicate(Predicate predicate) {
        List values;
        if (predicate.getLhs().getType() != ExpressionContext.Type.IDENTIFIER) {
            return false;
        }
        Predicate.Type predicateType = predicate.getType();
        if (predicateType == Predicate.Type.EQ || predicateType == Predicate.Type.RANGE) {
            return true;
        }
        return predicateType == Predicate.Type.IN && (values = ((InPredicate)predicate).getValues()).size() <= this._inPredicateThreshold;
    }

    @Override
    boolean pruneSegmentWithPredicate(IndexSegment segment, Predicate predicate, Map<String, DataSource> dataSourceCache, ValueBasedSegmentPruner.ValueCache cachedValues) {
        Predicate.Type predicateType = predicate.getType();
        if (predicateType == Predicate.Type.EQ) {
            return this.pruneEqPredicate(segment, (EqPredicate)predicate, dataSourceCache, cachedValues);
        }
        if (predicateType == Predicate.Type.IN) {
            return this.pruneInPredicate(segment, (InPredicate)predicate, dataSourceCache, cachedValues);
        }
        if (predicateType == Predicate.Type.RANGE) {
            return this.pruneRangePredicate(segment, (RangePredicate)predicate, dataSourceCache);
        }
        return false;
    }

    private boolean pruneEqPredicate(IndexSegment segment, EqPredicate eqPredicate, Map<String, DataSource> dataSourceCache, ValueBasedSegmentPruner.ValueCache valueCache) {
        ValueBasedSegmentPruner.ValueCache.CachedValue cachedValue;
        DataSource dataSource;
        String column = eqPredicate.getLhs().getIdentifier();
        DataSource dataSource2 = dataSource = segment instanceof ImmutableSegment ? segment.getDataSource(column) : dataSourceCache.computeIfAbsent(column, arg_0 -> ((IndexSegment)segment).getDataSource(arg_0));
        assert (dataSource != null);
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        if (!this.checkMinMaxRange(dataSourceMetadata, (cachedValue = valueCache.get(eqPredicate, dataSourceMetadata.getDataType())).getComparableValue())) {
            return true;
        }
        PartitionFunction partitionFunction = dataSourceMetadata.getPartitionFunction();
        if (partitionFunction != null) {
            Set partitions = dataSourceMetadata.getPartitions();
            assert (partitions != null);
            if (!partitions.contains(partitionFunction.getPartition(cachedValue.getValue()))) {
                return true;
            }
        }
        return false;
    }

    private boolean pruneInPredicate(IndexSegment segment, InPredicate inPredicate, Map<String, DataSource> dataSourceCache, ValueBasedSegmentPruner.ValueCache valueCache) {
        DataSource dataSource;
        List values = inPredicate.getValues();
        if (values.size() > this._inPredicateThreshold) {
            return false;
        }
        String column = inPredicate.getLhs().getIdentifier();
        DataSource dataSource2 = dataSource = segment instanceof ImmutableSegment ? segment.getDataSource(column) : dataSourceCache.computeIfAbsent(column, arg_0 -> ((IndexSegment)segment).getDataSource(arg_0));
        assert (dataSource != null);
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        List<ValueBasedSegmentPruner.ValueCache.CachedValue> cachedValues = valueCache.get(inPredicate, dataSourceMetadata.getDataType());
        for (ValueBasedSegmentPruner.ValueCache.CachedValue value : cachedValues) {
            if (!this.checkMinMaxRange(dataSourceMetadata, value.getComparableValue())) continue;
            return false;
        }
        return true;
    }

    private boolean pruneRangePredicate(IndexSegment segment, RangePredicate rangePredicate, Map<String, DataSource> dataSourceCache) {
        DataSource dataSource;
        String column = rangePredicate.getLhs().getIdentifier();
        DataSource dataSource2 = dataSource = segment instanceof ImmutableSegment ? segment.getDataSource(column) : dataSourceCache.computeIfAbsent(column, arg_0 -> ((IndexSegment)segment).getDataSource(arg_0));
        assert (dataSource != null);
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        FieldSpec.DataType dataType = dataSourceMetadata.getDataType();
        String lowerBound = rangePredicate.getLowerBound();
        Comparable lowerBoundValue = null;
        if (!lowerBound.equals("*")) {
            lowerBoundValue = ColumnValueSegmentPruner.convertValue(lowerBound, dataType);
        }
        boolean lowerInclusive = rangePredicate.isLowerInclusive();
        String upperBound = rangePredicate.getUpperBound();
        Comparable upperBoundValue = null;
        if (!upperBound.equals("*")) {
            upperBoundValue = ColumnValueSegmentPruner.convertValue(upperBound, dataType);
        }
        boolean upperInclusive = rangePredicate.isUpperInclusive();
        if (lowerBoundValue != null && upperBoundValue != null && (lowerInclusive && upperInclusive ? lowerBoundValue.compareTo(upperBoundValue) > 0 : lowerBoundValue.compareTo(upperBoundValue) >= 0)) {
            return true;
        }
        Comparable minValue = dataSourceMetadata.getMinValue();
        if (minValue != null && upperBoundValue != null && (upperInclusive ? upperBoundValue.compareTo(minValue) < 0 : upperBoundValue.compareTo(minValue) <= 0)) {
            return true;
        }
        Comparable maxValue = dataSourceMetadata.getMaxValue();
        return maxValue != null && lowerBoundValue != null && (lowerInclusive ? lowerBoundValue.compareTo(maxValue) > 0 : lowerBoundValue.compareTo(maxValue) >= 0);
    }

    private boolean checkMinMaxRange(DataSourceMetadata dataSourceMetadata, Comparable value) {
        Comparable minValue = dataSourceMetadata.getMinValue();
        if (minValue != null && value.compareTo(minValue) < 0) {
            return false;
        }
        Comparable maxValue = dataSourceMetadata.getMaxValue();
        return maxValue == null || value.compareTo(maxValue) <= 0;
    }
}

