/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.pruner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.pinot.core.query.config.SegmentPrunerConfig;
import org.apache.pinot.core.query.pruner.SegmentPruner;
import org.apache.pinot.core.query.pruner.SegmentPrunerProvider;
import org.apache.pinot.core.query.pruner.SegmentPrunerStatistics;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.trace.InvocationScope;
import org.apache.pinot.spi.trace.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPrunerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentPrunerService.class);
    private final List<SegmentPruner> _segmentPruners;
    private final Map<SegmentPruner, BiConsumer<SegmentPrunerStatistics, Integer>> _prunerStatsUpdaters;

    public SegmentPrunerService(SegmentPrunerConfig config) {
        int numPruners = config.numSegmentPruners();
        this._prunerStatsUpdaters = new HashMap<SegmentPruner, BiConsumer<SegmentPrunerStatistics, Integer>>();
        this._segmentPruners = new ArrayList<SegmentPruner>(numPruners);
        for (int i = 0; i < numPruners; ++i) {
            String segmentPrunerName = config.getSegmentPrunerName(i);
            LOGGER.info("Adding segment pruner: {}", (Object)segmentPrunerName);
            SegmentPruner pruner = SegmentPrunerProvider.getSegmentPruner(segmentPrunerName, config.getSegmentPrunerConfig(i));
            if (pruner != null) {
                this._segmentPruners.add(pruner);
                switch (segmentPrunerName.toLowerCase()) {
                    case "selectionquerysegmentpruner": {
                        this._prunerStatsUpdaters.put(pruner, SegmentPrunerStatistics::setLimitPruned);
                        break;
                    }
                    case "columnvaluesegmentpruner": 
                    case "bloomfiltersegmentpruner": {
                        this._prunerStatsUpdaters.put(pruner, SegmentPrunerStatistics::setValuePruned);
                        break;
                    }
                    default: {
                        this._prunerStatsUpdaters.put(pruner, (stats, value) -> {});
                        break;
                    }
                }
                continue;
            }
            LOGGER.warn("could not create segment pruner: {}", (Object)segmentPrunerName);
        }
        assert (this._segmentPruners.stream().allMatch(this._prunerStatsUpdaters::containsKey)) : "No defined stats updater for pruner " + this._segmentPruners.stream().filter(p -> !this._prunerStatsUpdaters.containsKey(p)).findAny().orElseThrow(IllegalStateException::new);
    }

    @Deprecated
    public List<IndexSegment> prune(List<IndexSegment> segments, QueryContext query) {
        return this.prune(segments, query, new SegmentPrunerStatistics());
    }

    public List<IndexSegment> prune(List<IndexSegment> segments, QueryContext query, SegmentPrunerStatistics stats) {
        return this.prune(segments, query, stats, null);
    }

    public List<IndexSegment> prune(List<IndexSegment> segments, QueryContext query, SegmentPrunerStatistics stats, @Nullable ExecutorService executorService) {
        try (InvocationScope scope = Tracing.getTracer().createScope(SegmentPrunerService.class);){
            segments = SegmentPrunerService.removeInvalidSegments(segments, query, stats);
            int invokedPrunersCount = 0;
            for (SegmentPruner segmentPruner : this._segmentPruners) {
                if (!segmentPruner.isApplicableTo(query)) continue;
                ++invokedPrunersCount;
                InvocationScope prunerScope = Tracing.getTracer().createScope(segmentPruner.getClass());
                try {
                    int originalSegmentsSize = segments.size();
                    prunerScope.setNumSegments(originalSegmentsSize);
                    segments = segmentPruner.prune(segments, query, executorService);
                    this._prunerStatsUpdaters.get(segmentPruner).accept(stats, originalSegmentsSize - segments.size());
                }
                finally {
                    if (prunerScope == null) continue;
                    prunerScope.close();
                }
            }
            scope.setNumChildren(invokedPrunersCount);
        }
        return segments;
    }

    private static List<IndexSegment> removeInvalidSegments(List<IndexSegment> segments, QueryContext query, SegmentPrunerStatistics stats) {
        int selected = 0;
        int invalid = 0;
        for (IndexSegment segment : segments) {
            if (SegmentPrunerService.isEmptySegment(segment)) continue;
            if (SegmentPrunerService.isInvalidSegment(segment, query)) {
                ++invalid;
                continue;
            }
            segments.set(selected++, segment);
        }
        stats.setInvalidSegments(invalid);
        return segments.subList(0, selected);
    }

    private static boolean isEmptySegment(IndexSegment segment) {
        return segment.getSegmentMetadata().getTotalDocs() == 0;
    }

    private static boolean isInvalidSegment(IndexSegment segment, QueryContext query) {
        return !segment.getColumnNames().containsAll(query.getColumns());
    }
}

