/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.PostAggregationHandler;
import org.apache.pinot.core.query.reduce.ReducerDataSchemaUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.utils.rewriter.ResultRewriteUtils;
import org.apache.pinot.core.query.utils.rewriter.RewriterResult;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.spi.trace.Tracing;
import org.roaringbitmap.RoaringBitmap;

public class AggregationDataTableReducer
implements DataTableReducer {
    private final QueryContext _queryContext;
    private final AggregationFunction[] _aggregationFunctions;

    public AggregationDataTableReducer(QueryContext queryContext) {
        this._queryContext = queryContext;
        this._aggregationFunctions = this._queryContext.getAggregationFunctions();
        assert (this._aggregationFunctions != null);
    }

    @Override
    public void reduceAndSetResults(String tableName, DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, BrokerResponseNative brokerResponseNative, DataTableReducerContext reducerContext, BrokerMetrics brokerMetrics) {
        dataSchema = ReducerDataSchemaUtils.canonicalizeDataSchemaForAggregation(this._queryContext, dataSchema);
        if (dataTableMap.isEmpty()) {
            DataSchema resultTableSchema = new PostAggregationHandler(this._queryContext, this.getPrePostAggregationDataSchema(dataSchema)).getResultDataSchema();
            brokerResponseNative.setResultTable(new ResultTable(resultTableSchema, Collections.emptyList()));
            return;
        }
        Collection<DataTable> dataTables = dataTableMap.values();
        if (this._queryContext.isServerReturnFinalResult()) {
            if (dataTables.size() == 1) {
                this.processSingleFinalResult(dataSchema, dataTables.iterator().next(), brokerResponseNative);
            } else {
                this.reduceWithFinalResult(dataSchema, dataTables, brokerResponseNative);
            }
        } else {
            this.reduceWithIntermediateResult(dataSchema, dataTables, brokerResponseNative);
        }
    }

    private void reduceWithIntermediateResult(DataSchema dataSchema, Collection<DataTable> dataTables, BrokerResponseNative brokerResponseNative) {
        int numAggregationFunctions = this._aggregationFunctions.length;
        Object[] intermediateResults = new Object[numAggregationFunctions];
        for (DataTable dataTable : dataTables) {
            Tracing.ThreadAccountantOps.sampleAndCheckInterruption();
            for (int i = 0; i < numAggregationFunctions; ++i) {
                RoaringBitmap nullBitmap;
                DataSchema.ColumnDataType columnDataType = dataSchema.getColumnDataType(i);
                Object intermediateResultToMerge = this._queryContext.isNullHandlingEnabled() ? ((nullBitmap = dataTable.getNullRowIds(i)) != null && nullBitmap.contains(0) ? null : AggregationFunctionUtils.getIntermediateResult(dataTable, columnDataType, 0, i)) : AggregationFunctionUtils.getIntermediateResult(dataTable, columnDataType, 0, i);
                Object mergedIntermediateResult = intermediateResults[i];
                intermediateResults[i] = mergedIntermediateResult == null ? intermediateResultToMerge : this._aggregationFunctions[i].merge(mergedIntermediateResult, intermediateResultToMerge);
            }
        }
        Object[] finalResults = new Object[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunction aggregationFunction = this._aggregationFunctions[i];
            Object result = aggregationFunction.extractFinalResult(intermediateResults[i]);
            finalResults[i] = result != null ? aggregationFunction.getFinalResultColumnType().convert(result) : null;
        }
        brokerResponseNative.setResultTable(this.reduceToResultTable(this.getPrePostAggregationDataSchema(dataSchema), finalResults));
    }

    private void processSingleFinalResult(DataSchema dataSchema, DataTable dataTable, BrokerResponseNative brokerResponseNative) {
        int numAggregationFunctions = this._aggregationFunctions.length;
        Object[] finalResults = new Object[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            DataSchema.ColumnDataType columnDataType = dataSchema.getColumnDataType(i);
            if (this._queryContext.isNullHandlingEnabled()) {
                RoaringBitmap nullBitmap = dataTable.getNullRowIds(i);
                if (nullBitmap != null && nullBitmap.contains(0)) {
                    finalResults[i] = null;
                    continue;
                }
                finalResults[i] = AggregationFunctionUtils.getConvertedFinalResult(dataTable, columnDataType, 0, i);
                continue;
            }
            finalResults[i] = AggregationFunctionUtils.getConvertedFinalResult(dataTable, columnDataType, 0, i);
        }
        brokerResponseNative.setResultTable(this.reduceToResultTable(dataSchema, finalResults));
    }

    private void reduceWithFinalResult(DataSchema dataSchema, Collection<DataTable> dataTables, BrokerResponseNative brokerResponseNative) {
        int numAggregationFunctions = this._aggregationFunctions.length;
        Comparable[] finalResults = new Comparable[numAggregationFunctions];
        for (DataTable dataTable : dataTables) {
            for (int i = 0; i < numAggregationFunctions; ++i) {
                RoaringBitmap nullBitmap;
                Tracing.ThreadAccountantOps.sampleAndCheckInterruption();
                DataSchema.ColumnDataType columnDataType = dataSchema.getColumnDataType(i);
                Object finalResultToMerge = this._queryContext.isNullHandlingEnabled() ? ((nullBitmap = dataTable.getNullRowIds(i)) != null && nullBitmap.contains(0) ? null : AggregationFunctionUtils.getFinalResult(dataTable, columnDataType, 0, i)) : AggregationFunctionUtils.getFinalResult(dataTable, columnDataType, 0, i);
                Comparable mergedFinalResult = finalResults[i];
                finalResults[i] = mergedFinalResult == null ? finalResultToMerge : this._aggregationFunctions[i].mergeFinalResult(mergedFinalResult, finalResultToMerge);
            }
        }
        Object[] convertedFinalResults = new Object[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunction aggregationFunction = this._aggregationFunctions[i];
            Comparable result = finalResults[i];
            convertedFinalResults[i] = result != null ? aggregationFunction.getFinalResultColumnType().convert((Object)result) : null;
        }
        brokerResponseNative.setResultTable(this.reduceToResultTable(this.getPrePostAggregationDataSchema(dataSchema), convertedFinalResults));
    }

    private ResultTable reduceToResultTable(DataSchema dataSchema, Object[] finalResults) {
        PostAggregationHandler postAggregationHandler = new PostAggregationHandler(this._queryContext, dataSchema);
        DataSchema resultDataSchema = postAggregationHandler.getResultDataSchema();
        Object[] row = postAggregationHandler.getResult(finalResults);
        RewriterResult resultRewriterResult = ResultRewriteUtils.rewriteResult(resultDataSchema, Collections.singletonList(row));
        resultDataSchema = resultRewriterResult.getDataSchema();
        List<Object[]> rows = resultRewriterResult.getRows();
        DataSchema.ColumnDataType[] columnDataTypes = resultDataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        for (Object[] rewrittenRow : rows) {
            for (int j = 0; j < numColumns; ++j) {
                rewrittenRow[j] = columnDataTypes[j].format(rewrittenRow[j]);
            }
        }
        return new ResultTable(resultDataSchema, rows);
    }

    private DataSchema getPrePostAggregationDataSchema(DataSchema dataSchema) {
        int numAggregationFunctions = this._aggregationFunctions.length;
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            columnDataTypes[i] = this._aggregationFunctions[i].getFinalResultColumnType();
        }
        return new DataSchema(dataSchema.getColumnNames(), columnDataTypes);
    }
}

